if (!RedactorPlugins) var RedactorPlugins = {};

(function ($) {
    RedactorPlugins.fontcolor = function () {
        return {
            init: function () {
                var colors = [
                    '#ffffff', '#000000', '#eeece1', '#1f497d', '#4f81bd', '#c0504d', '#9bbb59', '#8064a2', '#4bacc6', '#f79646', '#ffff00',
                    '#f2f2f2', '#7f7f7f', '#ddd9c3', '#c6d9f0', '#dbe5f1', '#f2dcdb', '#ebf1dd', '#e5e0ec', '#dbeef3', '#fdeada', '#fff2ca',
                    '#d8d8d8', '#595959', '#c4bd97', '#8db3e2', '#b8cce4', '#e5b9b7', '#d7e3bc', '#ccc1d9', '#b7dde8', '#fbd5b5', '#ffe694',
                    '#bfbfbf', '#3f3f3f', '#938953', '#548dd4', '#95b3d7', '#d99694', '#c3d69b', '#b2a2c7', '#b7dde8', '#fac08f', '#f2c314',
                    '#a5a5a5', '#262626', '#494429', '#17365d', '#366092', '#953734', '#76923c', '#5f497a', '#92cddc', '#e36c09', '#c09100',
                    '#7f7f7f', '#0c0c0c', '#1d1b10', '#0f243e', '#244061', '#632423', '#4f6128', '#3f3151', '#31859b', '#974806', '#7f6000'
                ];

                var buttons = ['fontcolor', 'backcolor'];

                for (var i = 0; i < 2; i++) {
                    var name = buttons[i];

                    var button = this.button.add(name, this.lang.get(name));
                    var $dropdown = this.button.addDropdown(button);

                    $dropdown.width(242);
                    this.fontcolor.buildPicker($dropdown, name, colors);

                }
            },
            buildPicker: function ($dropdown, name, colors) {
                var rule = (name == 'backcolor') ? 'background-color' : 'color';

                var len = colors.length;
                var self = this;
                var func = function (e) {
                    e.preventDefault();
                    self.fontcolor.set($(this).data('rule'), $(this).attr('rel'));
                };

                for (var z = 0; z < len; z++) {
                    var color = colors[z];

                    var $swatch = $('<a rel="' + color + '" data-rule="' + rule + '" href="#" style="float: left; font-size: 0; border: 2px solid #fff; padding: 0; margin: 0; width: 22px; height: 22px;"></a>');
                    $swatch.css('background-color', color);
                    $swatch.on('click', func);

                    $dropdown.append($swatch);
                }

                var $elNone = $('<a href="#" style="display: block; clear: both; padding: 5px; font-size: 12px; line-height: 1;"></a>').html(this.lang.get('none'));
                $elNone.on('click', $.proxy(function (e) {
                    e.preventDefault();
                    this.fontcolor.remove(rule);

                }, this));

                $dropdown.append($elNone);
            },
            set: function (rule, type) {
                this.inline.format('span', 'style', rule + ': ' + type + ';');
            },
            remove: function (rule) {
                this.inline.removeStyleRule(rule);
            }
        };
    };
})(jQuery);