<?php
/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use app\modules\user\models\User;

/**
 * @var yii\web\View                 $this
 * @var dektrium\user\models\User    $user
 * @var dektrium\user\models\Profile $profile
 * @var dektrium\user\Module         $module
 */
$this->title = Yii::t('user', 'Update User Password');
$this->params['breadcrumbs'][] = ['label' => Yii::t('user', 'Users'), 'url' => ["/user"]];
$this->params['breadcrumbs'][] = $this->title;
?>

<?=
$this->render('/_alert', [
    'module' => Yii::$app->getModule('user'),
])
?>
<div class="alert alert-info">
    <?= Yii::t('user', 'Registered at {0, date, MMMM dd, YYYY HH:mm} from {1}', [$user->created_at, is_null($user->registration_ip) ? 'N/D' : $user->registration_ip]) ?>
</div>
<div class="col-xs-12">
    <div class="col-lg-8 col-sm-8 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-plus"></i> Update User Password</h3></div>
    <div class="col-lg-4 col-sm-4 col-xs-12 no-padding" style="padding-top: 20px !important;">
        <div class="col-xs-4"></div>
        <div class="col-xs-4"></div>
        <div class="col-xs-4">
		  <?php
				if (Yii::$app->user->can('/user/default/index')) {
					echo Html::a('<i class="fa fa-table "></i> Users List', ["/user"], ['class' => 'btn  btn-primary btn-large']);
				}
			?>
        </div>
    </div>
</div>
<div class="centers-create">
    <div class="col-xs-12 col-lg-12">
	<div class="box-success box view-item col-xs-12 col-lg-12">
		<div class="courses-form">
                <?php
                $form = ActiveForm::begin([
                            'enableAjaxValidation' => false,
                            'enableClientValidation' => true,
                            'validateOnBlur' => false,
                            'options' => ['class' => 'form-horizontal'],
                            'fieldConfig' => [
								'template' => "{label}{input}{error}",
							],
                ]);
                ?>
                <div class="col-xs-12 col-lg-12 no-padding">
					<div class="col-xs-6 col-sm-6 col-lg-6">
					  <?= $form->field($user, 'username')->textInput(['readonly' => true]) ?>
					</div>
				</div>
				
				<div class="col-xs-12 col-lg-12 no-padding">
					<div class="col-xs-6 col-sm-6 col-lg-6">
					   <?= $form->field($user, 'email')->textInput(['readonly' => true]) ?>
					</div>
				</div>
				
				<div class="col-xs-12 col-lg-12 no-padding">
					<div class="col-xs-6 col-sm-6 col-lg-6">
					  <?= $form->field($user, 'password')->passwordInput() ?>
					</div>
				</div>
				
				<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
					<div class="col-xs-6">
	        			<?= Html::submitButton(Yii::t('user', 'Save'), ['class' => 'btn btn-block btn-success']) ?>
					</div>
					<div class="col-xs-6">
						<?= Html::a(Yii::t('user', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
					</div>
				</div>
                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>


