<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use dektrium\user\helpers\RoleHelper;
use dektrium\user;
use yii\helpers\ArrayHelper;
use kartik\widgets\Select2;
use yii\widgets\MaskedInput;

$this->title = Yii::t('user', 'Add User Account');
$this->params['breadcrumbs'][] = ['label' => Yii::t('user', 'User'), 'url' => ['/user/default/index']];
$this->params['breadcrumbs'][] = $this->title;
?> 
<div class="col-xs-12">
    <div class="col-lg-8 col-sm-8 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-plus"></i> <?= Html::encode($this->title) ?></h3></div>
    <div class="col-lg-4 col-sm-4 col-xs-12 no-padding" style="padding-top: 20px !important;">
        <div class="col-xs-4"></div>
        <div class="col-xs-4"></div>
        <div class="col-xs-4 left-padding">
            <?= Html::a(Yii::t('user', 'Back'), ['/user/default/index'], ['class' => 'btn btn-block btn-back']) ?>
        </div>
    </div>
</div>

<div class="centers-create">
    <div class="col-xs-12 col-lg-12">
	<div class="box-success box view-item col-xs-12 col-lg-12">
		<div class="courses-form">
		    <?php $form = ActiveForm::begin([
                            'id' => 'add-form',
                            'enableAjaxValidation' => false,
                            'enableClientValidation' => true,
                            'validateOnBlur' => false,
                            'options' => ['class' => 'form-horizontal'],
                            'fieldConfig' => [
								'template' => "{label}{input}{error}",
							],
                ]); ?>
				<div class="col-xs-12 col-lg-12 no-padding">
					<div class="col-xs-6 col-sm-6 col-lg-6">
					  <?= $form->field($model, 'email')->textInput(['placeholder' => 'Email ID']) ?>
					</div>
				</div>

				<div class="col-xs-12 col-lg-12 no-padding">
					<div class="col-xs-6 col-sm-6 col-lg-6">
						<?= $form->field($model, 'username')->textInput(['placeholder' => 'Username']) ?>
					</div>
				</div>

				<div class="col-xs-12 col-lg-12 no-padding">
					<div class="col-xs-6 col-sm-6 col-lg-6">
						<?= $form->field($model, 'password')->passwordInput(['placeholder' => 'Password']) ?>
					</div>
				 </div>

				<div class="col-xs-12 col-lg-12 no-padding">
					<div class="col-xs-6 col-sm-6 col-lg-6">
						<?= $form->field($model, 'role')->dropDownList(RoleHelper::getRoleDrop(Yii::$app->user->identity->project, Yii::$app->user->identity->role), ['prompt' => 'Select a role..']) ?>
					</div>
				</div>
	    		<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
					<div class="col-xs-6">
	        			<?= Html::submitButton(Yii::t('user', 'Create'), ['class' => 'btn btn-block btn-success']) ?>
					</div>
					<div class="col-xs-6">
						<?= Html::a(Yii::t('user', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
					</div>
	    		</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
</div>

