<?php

namespace dektrium\user\controllers;

use yii;
use dektrium\user\Finder;
use dektrium\user\models\User;
use dektrium\user\models\UserSearch;
use yii\base\Model;
use dektrium\user\helpers\RoleHelper;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\Response;
use yii\widgets\ActiveForm;

class DefaultController extends Controller {

    protected $finder;

    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'block' => ['post']
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'block'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ]
            ]
        ];
    }

    public function __construct($id, $module, Finder $finder, $config = []) {
        $this->finder = $finder;
        parent::__construct($id, $module, $config);
    }

    public function actionIndex() {

        $searchModel = \Yii::createObject(UserSearch::className());
        if (Yii::$app->user->identity->id != 1) {
            $searchModel->client_id = Yii::$app->user->identity->client_id;
        }
        $dataProvider = $searchModel->csearch(Yii::$app->request->queryParams, RoleHelper::getPermRoleStr(Yii::$app->user->identity->project, Yii::$app->user->identity->role));

        return $this->render('index', [
                    'dataProvider' => $dataProvider,
                    'searchModel' => $searchModel,
        ]);
    }

    public function actionBlock($id, $back = 'index') {
        if ($id == \Yii::$app->user->getId()) {
            \Yii::$app->getSession()->setFlash('success', \Yii::t('user', 'You can not Block/Unblock your own account'));
        } else {
            $user = $this->findModel($id);
            if ($user->getIsBlocked()) {
                $user->unblock();
                \Yii::$app->getSession()->setFlash('success', \Yii::t('user', 'User has been unblocked'));
            } else {
                $user->block();
                \Yii::$app->getSession()->setFlash('success', \Yii::t('user', 'User has been blocked'));
            }
        }
        return $this->redirect(Yii::$app->request->referrer);
    }

    protected function findModel($id) {
        $user = $this->finder->findUserById($id);
        if ($user === null) {
            throw new NotFoundHttpException('The requested page does not exist');
        }
        return $user;
    }

}
