# Contributing to Yii2-rbac

Please take a moment to review this document in order to make the contribution process easy and effective for everyone
involved.

Following these guidelines helps to communicate that you respect the time of the developers managing and developing 
this open source project. In return, they should reciprocate that respect in addressing your issue or assessing
patches and features.

## Do you have a question or problem with using Yii2-rbac?

Ask any question about how to use Yii2-rbac on [our forum](http://dektrium.com).

## Did you find a security issue?

Please don't use forum or Github issues to report security issues. Instead contact us directly by using following email
address: `dmeroff@gmail.com`.

## Did you find a bug?

- Ensure the bug was not already reported by searching on GitHub under Issues.
- If you're unable to find an open issue addressing the problem, open a new one. Be sure to include a title and clear
 description, as much relevant information as possible, and a code sample or an executable test case demonstrating the
 expected behavior that is not occurring.
 
## Do you intend to add a new feature or change an existing one?

- Suggest your change on [our forum](http://dektrium.com) and start writing code.
- Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are
 primarily intended for bug reports and fixes.

## Did you write a patch that fixes a bug?

- Ensure your code follows PSR-2 code style
- Commit your changes in logical chunks. Please adhere to
 [these git commit message guidelines](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html) or your
 code is unlikely be merged into the main project. Use Git's interactive rebase feature to tidy up your commits before
 making them public.
 - Open a new GitHub pull request with the patch.
 - Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

> **IMPORTANT**: By submitting a patch, you agree to allow the project owner to license your work under the same license
 as that used by the project.