<?php
use yii\helpers\Html;
use yii\widgets\ListView;
use yii\helpers\Url;
use yii\db\Query;
use backend\models\State;
use backend\models\Blog;
use backend\models\StateFaq;
/* @var $this yii\web\View */

$js = <<<JS
var modal1 = document.getElementById("myModal1");
var btn1 = document.getElementById("myBtn1");
var span1 = document.getElementsByClassName("close1")[0];
btn1.onclick = function() {
  modal1.style.display = "block";
}
span1.onclick = function() {
  modal1.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal1.style.display = "none";
  }
}
var modal = document.getElementById("myModal");
var btn = document.getElementById("myBtn");
var span = document.getElementsByClassName("close")[0];
btn.onclick = function() {
  modal.style.display = "block";
}
span.onclick = function() {
  modal.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
JS;
$this->registerJs($js);

$this->title = $model->meta_title;
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => $model->meta_description,
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => $model->meta_keyword,
]);
if($model->image != '') {
  $ogimage = 'https://www.exploreourindia.com'. Yii::$app->urlManagerBackend->baseUrl.'/images/state/'.$model->image;
} else {
  $ogimage = 'https://www.exploreourindia.com/frontend/web/images/logo.png';
}
$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => $model->meta_description], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => $ogimage], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => $model->meta_description], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => $ogimage], 'twitter:image');
?>
<style>
.carousel-item-next, .carousel-item-prev, .carousel-item.active, .dropdown-menu.show, .tab-content > .active {
  display: block;
}
.faq-container {
  width: 100%;
}
.faq-item {
  margin-bottom: 10px;
  border: 1px solid #ccc;
  border-radius: 6px;
  overflow: hidden;
}
.faq-question {
  background: #f4f4f4;
  padding: 15px;
  font-weight: bold;
  cursor: pointer;
  position: relative;
}
.faq-answer {
  display: none;
  padding: 15px;
  background: #fff;
}
.faq-item.active .faq-answer {
  display: block;
}
.faq-question::after {
  content: "\f107";
  font-family: "Font Awesome 6 Free";
  font-weight: 900;
  position: absolute;
  right: 20px;
  transition: transform 0.3s;
}
.faq-item.active .faq-question::after {
  transform: rotate(180deg); /* Points up */
}
</style>
<div role="main" class="main">
    <section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
      <div class="container">
        <div class="row">
          <div class="col-md-12 align-self-left order-1">
            <ul class="breadcrumb d-block text-left">
              <li><?=Html::a("Home", ['/site/index'])?></li>
              <li class="active"><?=Html::a('state', ['/state/index'])?></li>
			  <li class="active"><?=Html::a($model->state_name, ['/state/view', 'slug' => $model->slug])?></li>
              <li class="active"><?=$model->heading?></li>
            </ul>
          </div>
        </div>
      </div>
    </section>
<div class="container">
      <div class="row">
        <div class="col-lg-9 order-lg-1">
		<div class="heading heading-border heading-middle-border">
            <h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary"><?php echo $model->state_name?></strong></h3>
          </div>
		<div class="blog-posts">
		   <article class="post post-large m-0">
               <div class="post-image ml-0">
                 <?php if($model->image != '') {?>
                   <img src="<?=Yii::$app->urlManagerBackend->baseUrl.'/images/state/'.$model->image?>" class="img-fluid img-thumbnail img-thumbnail-no-borders rounded-0" alt="<?=$model->heading;?>" />
                 <?php } else { ?>
	               <img src="<?=Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg'?>" class="img-fluid img-thumbnail img-thumbnail-no-borders rounded-0" alt="<?=$model->heading;?>" />
	             <?php } ?>
				</div>
              <div class="post-content ">
                <?php if(isset($model->heading)) {?>
				<h1 class="font-weight-semibold text-6 line-height-3 mb-3"><?php echo $model->heading?></h1>
				<?php }  else { ?>
				<h1 class="font-weight-semibold text-6 line-height-3 mb-3"><?php echo $model->state_name?></h1>
				<?php } ?>
                <?=$model->introduction?>

<?php $faqblogQuery = StateFaq::find()->where(['status' => 1])->andwhere(['state_id' => $model->id])->orderBy(['id' => SORT_ASC])->all();
			         if(count($faqblogQuery) != '') {?>
					 <div class="faq-container mt-4 mb-4">
						<h4> Faq About <?=$model->state_name?></h4>
						 <?php $j=1; 
		                     foreach($faqblogQuery as $FaqposttQuery) {?>
							  <div class="faq-item">
								<div class="faq-question">Q<?=$j?>. <?=$FaqposttQuery->question?></div>
								<div class="faq-answer"><p><b>Ans:</b> <?=strip_tags($FaqposttQuery->answer)?></p></div>
							  </div>
						  <?php $j++; } ?>
						</div>					 
			   <?php } ?>
              </div>
<div class="heading heading-border heading-middle-border mrgnlfta">
	  <h3 class="text-4">
<strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary">Tourist Places in <?php echo $model->state_name?></strong></h3>
</div>
              <div class="hpanel panel-group sidebar mrgnlfta" id="accordion" role="tablist" aria-multiselectable="true">
              <div class="tabs tabs-dark mb-4 pb-2">
              <ul class="nav nav-tabs">
			  <?php $categoryQuery = backend\models\Category::find()->where(['status' => 1])->orderBy(['id' => SORT_ASC])->all();
		        $i=1;foreach($categoryQuery as $categorymenu) {?>
				   <li class="nav-item"><a class="nav-link <?php if($i==1) { ?>show<?php } ?> text-1 font-weight-bold text-uppercase <?php if($i==1) { ?>active<?php } ?>" href="#catall<?=$categorymenu->id?>" data-toggle="tab"><?=$categorymenu->name?></a></li>
				 <?php $i++; } ?>  
              </ul>    
              <div class="tab-content">
			  <?php $catQuery = backend\models\Category::find()->where(['status' => 1])->orderBy(['id' => SORT_ASC])->all();
		        $j=1;foreach($catQuery as $postsQuery) {?>
                <div class="tab-pane <?php if($j==1) {?>active<?php } ?>" id="catall<?=$postsQuery->id?>">
                  <ul class="simple-post-list">
				   <?php $postQuery = backend\models\Post::find()->where(['status' => 1])->andwhere(['state_id' => $model->id])->andwhere(['category_id' => $postsQuery->id])->orderBy(['id' => SORT_ASC])->all();
		               if(count($postQuery) != '') {?>
                        <li><div class="row">
					   <?php foreach($postQuery as $postallQuery) {?>						
						
						<div class="col-lg-6 mb-4 pb-1 order-1 order-lg-2">
						  <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-2 mb-2">
							<div class="row">
							  <div class="col">
								<?php if($postallQuery->image != '') {?>
								   <?= Html::a("<img src='".Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$postallQuery->image."' class='float-left img-fluid' style='width:150px; margin-right: 10px; float: left; ' alt='".$postallQuery->title."'>",['/post/view/', 'slug' => $postallQuery->slug])  ?>
								<?php } else { ?>
								  <?= Html::a("<img src='".Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg'."' class='float-left img-fluid' style='width:150px; margin-right: 10px; float: left; ' alt='".$postallQuery->title."'>",['/post/view/', 'slug' => $postallQuery->slug])  ?>
								<?php } ?>
						<?=Html::a('<h4 class="d-block pb-0 line-height-3 text-3 text-dark212 font-weight-bold mb-0 "> '.$postallQuery->title.'</h4>', ['/post/view', 'slug' => $postallQuery->slug])?>    
						 <?=Html::a('<p style="font-weight:normal">'.$postallQuery->limitTextWords(strip_tags($postallQuery->content), 35, true, true).'</p>', ['/post/view', 'slug' => $postallQuery->slug])?> 
							  </div>
							</div>
							</article>
							</div>
						<?php } ?>
						</div></li>
                       <?php } else { ?>
                       <li><div class='col-sm-12 text-center'><img src='<?=Yii::$app->urlManagerFrontend->baseUrl.'/images/nodata.jpg'?>' alt='No Data'></div></li>
					   <?php } ?>
                  </ul>
                </div>
				<?php $j++; } ?>
              </div>
            </div>
          
        </div>
            </article>
			</div>
          </div>
		
		<div class="col-lg-3 mb-4 mb-lg-0 sidebar order-lg-2">  
        <div class="hpanel panel-group sidebar" id="accordion" role="tablist" aria-multiselectable="true">
		   <div class="toggle toggle-primary" data-plugin-toggle="" data-plugin-options="{ 'isAccordion': true }">
			<section class="toggle active">
				<aside class="aside bgcolortop">
				   <h3 class="aside-title">The Best state to visit in India</h3>
				</aside>
				<div class="toggle-content">
					<div class="panel-body"> 
						<div class="form-group">
						  <input type="text" value="" placeholder="Select Your City..." maxlength="100" class="form-control" name="name" required>
						</div>
					</div>
					<form role="form" action="https://www.exploreourindia.com/state" method="post" name="statewiselist" id="statewiselist">
					<input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
					<div class="panel-body"> 
						<div class="checkbox">
							<label style="font-size: 1em; margin-bottom:0px;">
								<input type="checkbox" name="stateid[]" value="10">
								<span class="cr"><i class="cr-icon fa fa-check"></i></span>
								Delhi
							</label>
						</div>
					</div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="46">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Goa
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="70">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Jammu & Kashmir
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="39">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Uttarakhand
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="49">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Himachal Pradesh
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="74">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Leh-Ladakh
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="55">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Manipur
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="62">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Sikkim
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="52">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Kerala
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="43">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Assam
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
						<input type="submit" class="btn btn-outline btn-secondary mb-2 mt-2" style="width:100%" value="Apply">
					</div>
				</form>
				<div class="panel-body"> 
				  <div class="checkbox">
					  <button id="myBtn1" class="morebtn">30 More</button>
					  <div id="myModal1" class="modal1">
							  <div class="col-lg-12">
							  <form role="form" action="https://www.exploreourindia.com/state" method="post" name="statewiselistALL" id="statewiselistALL">
							  <div class="modal1-content">
							  <span1 class="close1">&times;</span1>
							  <div class="row pb-1">
							  <div class="col-lg-12" style="margin:0px 0px;">
							  <h4>Select Your Destination</h4>
							  </div>
							  
								<input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
								<?php
								  $postAllState = State::find()->where(['status' => 1])->orderBy('state_name ASC')->all();
								  foreach($postAllState as $postAllStates) {
								?>
									<div class="col-lg-3" style="margin:1px 0px;">
										<div class="panel-body"> 
										  <div class="checkbox">
											<label style="font-size: 12px; margin:0px 0px;">
												<input type="checkbox" name="stateid[]" value="<?=$postAllStates->id?>">
												<span class="cr"><i class="cr-icon fa fa-check"></i></span>
												<?=$postAllStates->state_name?>
											</label>
											</div>
										</div>
									</div>
								  <?php } ?>
									<div class="col-lg-3" style="margin:1px 0px;">
										<div class="panel-body"> 
										  <div class="checkbox">
											<input type="submit" class="btn btn-outline btn-secondary mb-2 mt-2" style="width:100%" value="Apply">
										  </div> 
										</div>
									</div>
								
								</div>
							</div>
							</form>
						</div>
					</div>
				   </div> 
				 </div> 
					   
				</div>
			</section>							
		  </div>
		</div>
        <div class="hpanel panel-group sidebar" id="accordion" role="tablist" aria-multiselectable="true">
		  <aside class="aside bgcolortop">
			<h3 class="aside-title">Recent Blog</h3>
		  </aside>
			<ul class="simple-post-list">
			   <?php
               $recentBlog = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(5)->all();
			   foreach($recentBlog as $recentBlogg) {?>
				<li>
				  <article>
					<div class="post-image">
					  <div class="img-thumbnail img-thumbnail-no-borders d-block">
						<?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$recentBlogg->image.'" alt="'.$recentBlogg->heading.'" class="border-radius-0" width="50" height="50">', ['/blog/view', 'slug' => $recentBlogg->slug])?>
					  </div>
					</div>
					<div class="post-info">
					  <h4 class="font-weight-normal text-3 mb-0"><?=Html::a($recentBlogg->heading, ['/blog/view', 'slug' => $recentBlogg->slug])?></h4>
					  <p><?php echo $recentBlogg->limitTextWords(strip_tags($recentBlogg->content), 20, true, true);?></p>
					</div>
				  </article>
				</li>
				<?php } ?>  
			</ul>
         </div>
        </div>
		</div>	
	</div>
</div>	
