<?php
use yii\helpers\Html;

$this->title = "About us | Explore Our India";
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => "About us",
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => " ABOUT US, About us ",
]);
$ogimage = 'https://www.exploreourindia.com/frontend/web/images/logo.png';
$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => 'About us'], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => $ogimage], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => 'About us'], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => $ogimage], 'twitter:image');
?>
<div role="main" class="main">
<section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
      <div class="container">
        <div class="row">
          <div class="col-md-12 align-self-left order-1">
            <ul class="breadcrumb d-block text-left">
              <li><?=Html::a("Home", ['/site/index'])?></li>
              <li class="active">About us</li>
            </ul>
          </div>
        </div>
      </div>
    </section>

<div class="container ">
      <div class="row">
        <div class="col-lg-12 order-lg-1">
        <div class="heading heading-border heading-middle-border">
            <h2 class="text-6"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary">ABOUT US</strong></h2>
          </div>
          
          <div class="blog-posts">
            <article class="post post-large">
              <div class="post-content mrgnlfta">
                
                <p>Interesting and Intriguing, India offers incredible holiday experiences through its cultural, topography, and wildlife diversity. With these amazing and unique experiences, this south Asian country conveniently finds its way into the world tourism map as one of the finest destinations for a holistic vacation.</p>
               <p>Hi! Thanks for checking us out.</p>
               <p>We’re <a href="https://www.exploreourindia.com" target="_blank">ExploreourIndia.com</a> and we started it as a blog to write travel stories. Our focus is on Indian tourism with 3 segments of travel: adventure, offbeat travel, and amazing experiences in India.</p>
               <p>India, one of the oldest civilizations in the world, has been bestowed with rich heritage culture. There are several stunning historical monuments in India across the length and breadth of the country. Aside from the rich heritage, culture, and architecture, the land is decorated with many forts, palaces, archaeological ruins, temples and churches. From the north to the south, east and west, you will find the country rife with minarets, palaces, forts, museums, mausoleums, gardens, and more. Also, there are 40 Nations Educational, Scientific and Cultural Organization (UNESCO) World Heritage Sites in India. The historical monuments in India are not only a peek into the cultural history of India but also an important tourist attraction.</p>
               <p>We also try to compile travel tips and ideas. ExploreourIndia.com creates itineraries, lists things to do, and travel tips, and loves to suggest where to eat and enjoy the nightlife. Compiling such tips & ideas allows us to help you plan your trip better, and that’s what this blog is all about!</p>
               <p><strong>"Hello Travelpayouts"</strong> – verification purposes only.</p>

               <p><strong>Have fun exploring our website! Feel free to comment and ask questions!</strong></p>
               <p>You can contact us at <a href="mailto:exploreourindia21@gmail.com">exploreourindia21@gmail.com</a></p>
               
               <h4>Support us by following us on social media platforms from the links below.</h4>
                <p>
                <span><i class="fab fa-facebook"></i> <a href="https://www.facebook.com/exploreourindiaofficial" target="_blank">/exploreourindiaofficial</a></span><br>
                <span><i class="fab fa-instagram"></i> <a href="https://www.instagram.com/exploreourindiaofficial" target="_blank">/exploreourindiaofficial</a></span><br>
                <span><i class="fab fa-twitter"></i> <a href="https://twitter.com/exploreourindi1" target="_blank">/exploreourindi1</a></span>
                </p>
                
              </div>
            </article>
          </div>
        </div>
      </div>
    </div>
</div>
