<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\widgets\MaskedInput;
use kartik\nav\NavX;

$this->title = 'Sign up now - Classic IAS Academy';
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'Sign up now - Classic IAS Academy',
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => 'Sign up now - Classic IAS Academy',
]);
?>
<section style="background-image: linear-gradient(to bottom right, #00CFFF, #0C4470);">
	<div class="container" style="display:flex; padding:15px">
		<div class="col-sm-6" style="position:relative; margin:auto">
			<div style="background:#fff; padding:50px; border-radius:5px">
				<h1 style="font-weight:bold; text-align:center; padding:15px">REGISTER</h1>
				<?php
                        $form = ActiveForm::begin([
                                    'id' => 'register1-form',
                                    'enableAjaxValidation' => true,
                                    'enableClientValidation' => true,
                                    'validateOnBlur' => true,
                                ])
                        ?>
                        <div class="form-group">
						    <label for="name">Full Name:</label>
                            <?= $form->field($r_model, 'name')->textInput(['placeholder' => 'Full Name'])->label(false) ?>
                        </div>
                        <div class="form-group">
						    <label for="email">Email:</label>
                            <?= $form->field($r_model, 'email')->textInput(['placeholder' => 'Email ID'])->label(false) ?>
                         </div>
                        <div class="form-group">
						       <label for="email">Phone No.:</label>
                                <?php
                                echo $form->field($r_model, 'phoneno')->widget(MaskedInput:: classname(), [
                                    'mask' => '9',
                                    'clientOptions' => ['repeat' => 10, 'greedy' => false],
                                ])->label(false);
                                ?>
                       </div>
                       <div class="form-group">
					    <label for="pwd">Password:</label>
                        <?= $form->field($r_model, 'password')->passwordInput(['placeholder' => 'Password'])->label(false) ?>
                       </div>
                       <div class="form-group">
					     <label for="pwd">Confirm Password:</label>
                         <?= $form->field($r_model, 'password_repeat')->passwordInput(['placeholder' => "Confirm Passowrd"])->label(false) ?>
                       </div>
					   <div>
                       <?= Html::submitButton(Yii::t('user', 'Register'), ['class' => 'submitbtn'])?>
                       </div>
                        <?php ActiveForm::end(); ?>
					<hr>
					
					<p style="text-align:center"><?=Html::a('Forget Password', ['/security/forgotpassword'])?></p>
					<p style="text-align:center">Allready Registered? <?=Html::a('Sign in now', ['/security/login'])?></p>
			</div>
		</div>
	</div>
</section>

<div style="height:20px"></div>
