<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Login - Classic IAS Academy';
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'Login - Classic IAS Academy',
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => 'Login - Classic IAS Academy',
]);
?>
<section style="background-image: linear-gradient(to bottom right, #00CFFF, #0C4470);">
	<div class="container" style="display:flex; padding:15px">
		<div class="col-sm-6" style="position:relative; margin:auto">
			<div style="background:#fff; padding:50px; border-radius:5px">
				<h1 style="font-weight:bold; text-align:center; padding:15px">LOGIN</h1>
				<?php if(\Yii::$app->session->hasFlash('Commfirm')) { ?>
				<p class="text-center" style="font-size:16px;color:green;"><?php echo \Yii::$app->session->getFlash('Commfirm'); ?></p>
				<?php } ?>
				      <?php
                        $form = ActiveForm::begin([
                                    'id' => 'login1-form',
                                    'enableAjaxValidation' => true,
                                    'enableClientValidation' => true,
                                    'validateOnBlur' => true,
                                ])
                        ?>
                            <div class="form-group">
							  <label for="email">Email/Phone No.:</label>
                              <?=
                                $form->field($l_model, 'login', ['inputOptions' => ['autofocus' => 'autofocus', 'class' => 'form-control', 'tabindex' => '1']])->textInput(['placeholder' => 'Email/Phone No.'])->label(false)
                                ?>
                            </div>
                            <div class="form-group">
							<label for="pwd">Password:</label>
                                <?=
                                $form->field($l_model, 'password', ['inputOptions' => ['class' => 'form-control', 'tabindex' => '2']])->passwordInput(['placeholder' => 'Password'])->label(Yii::t('user', 'Password'))->label(false)
                                ?>
                            </div>
                         <div class="checkbox">
                          <?php echo $form->field($l_model, 'rememberMe')->checkbox(['tabindex' => '4']) ?>
                         </div>
						 <?= Html::submitButton(Yii::t('user', '<i class="fa fa-sign-in"></i> Login'), ['class' => 'submitbtn', 'tabindex' => '3']) ?>
                       <?php ActiveForm::end(); ?>
					
					<hr>
					<p style="text-align:center"><?=Html::a('Forget Password', ['/security/forgotpassword'])?></p>
					<p style="text-align:center">Not a member? <?=Html::a('Sign up now', ['/security/register'])?></p>
					
			</div>
		</div>
	</div>
</section>

<div style="height:20px"></div>