<?php
use yii\helpers\Html;
use yii\widgets\ListView;
use yii\helpers\Url;
use yii\db\Query;
use backend\models\State;
use backend\models\News;
/* @var $this yii\web\View */

$js = <<<JS
var modal1 = document.getElementById("myModal1");
var btn1 = document.getElementById("myBtn1");
var span1 = document.getElementsByClassName("close1")[0];
btn1.onclick = function() {
  modal1.style.display = "block";
}
span1.onclick = function() {
  modal1.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal1.style.display = "none";
  }
}
var modal = document.getElementById("myModal");
var btn = document.getElementById("myBtn");
var span = document.getElementsByClassName("close")[0];
btn.onclick = function() {
  modal.style.display = "block";
}
span.onclick = function() {
  modal.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
JS;
$this->registerJs($js);

$this->title = "New Update";
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'New Update',
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => 'New Update',
]);
$ogimage = 'https://www.exploreourindia.com/frontend/web/images/logo.png';
$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => 'New Update'], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => $ogimage], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => 'New Update'], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => $ogimage], 'twitter:image');
?>
<div role="main" class="main">
    <section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
      <div class="container">
        <div class="row">
          <div class="col-md-12 align-self-left order-1">
            <ul class="breadcrumb d-block text-left">
              <li><?=Html::a("Home", ['/site/index'])?></li>
              <li class="active">News Update</li>
            </ul>
          </div>
        </div>
      </div>
    </section>
<div class="container">
      <div class="row">
        <div class="col-lg-12 order-lg-1">
		  <div class="row pb-1">
		    <div class="col-lg-12">
		  <?=
                ListView::widget([
                    'dataProvider' => $catDataProvider,
                    'itemView' => '_blog',
                    'layout' => '{items}',
                    'emptyText' => "<div class='panel add_box'>
                                    <table class='table'>
                                        <div class='col-sm-12 text-center'>
                                            <img src='".Yii::$app->urlManagerFrontend->baseUrl.'/images/nodata.jpg'."' alt='Main Title Here'>
                                            <p2><br/><b>Available Soon !</b></p2>
                                        </div>            
                                    </table>
                                </div>",
                ])
                ?>
     
					<div class="prod_pagination">
								<div class="row">
									<div class="col-sm-4 result-pagi">
									   
									</div>
									<div class="col-sm-8 text-right">
										<?=
										ListView::widget([

											'dataProvider' => $catDataProvider,
											'layout' => '{pager}',
										])
										?> 
									</div>
								</div>
					</div> 
				</div>
			</div>
		</div>		
	</div>
</div>	
