<?php
use yii\helpers\Html;
use yii\widgets\ListView;
use yii\helpers\Url;
use yii\db\Query;
use backend\models\Tag;
use backend\models\Post;
use \yii\db\Expression;
use backend\models\State;
use backend\models\Blog;
/* @var $this yii\web\View */

$js = <<<JS
var modal1 = document.getElementById("myModal1");
var btn1 = document.getElementById("myBtn1");
var span1 = document.getElementsByClassName("close1")[0];
btn1.onclick = function() {
  modal1.style.display = "block";
}
span1.onclick = function() {
  modal1.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal1.style.display = "none";
  }
}
var modal = document.getElementById("myModal");
var btn = document.getElementById("myBtn");
var span = document.getElementsByClassName("close")[0];
btn.onclick = function() {
  modal.style.display = "block";
}
span.onclick = function() {
  modal.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
JS;
$this->registerJs($js);
$this->title = 'Famous Places';
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'State',
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => 'State',
]);
$ogimage = 'https://www.exploreourindia.com/frontend/web/images/logo.png';
$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => 'State'], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => $ogimage], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => 'State'], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => $ogimage], 'twitter:image');
?>
<div role="main" class="main">
    <section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
      <div class="container">
        <div class="row">
          <div class="col-md-12 align-self-left order-1">
            <ul class="breadcrumb d-block text-left">
              <li><?=Html::a("Home", ['/site/index'])?></li>
            </ul>
          </div>
        </div>
      </div>
    </section>
<div class="container">
      <div class="row">
        <div class="col-lg-9 order-lg-1">
		<div class="heading heading-border heading-middle-border">
		  <h1 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary">Famous Places</strong></h1>
		</div>
		<?php
		  foreach($postQuery as $tagQueryy) {
		 ?>		    
			<div class="row pb-1">
			<div class="col-lg-12 mb-4 pb-1">
				<article>
					<div class="row">
					  <div class="col">
						<div class="thumb-info-caption-text sidebar">
							<aside class="aside">
							  <h3 class="aside-title" style="border-radius: 3px; margin-top:-10px;">
							   <?=Html::a($tagQueryy->famous_place_name, ['/famous-places/view', 'slug' => $tagQueryy->slug], ['class' => 'text-decoration-none text-color-light'])?>
							  </h3>
							</aside>
						</div>
					  </div>
					</div>
				</article>	
			</div>
            </div>
     		<?php } ?>
		</div>
		<div class="col-lg-3 mb-4 mb-lg-0 sidebar order-lg-2">  
        <div class="hpanel panel-group sidebar" id="accordion" role="tablist" aria-multiselectable="true">
		   <div class="toggle toggle-primary" data-plugin-toggle="" data-plugin-options="{ 'isAccordion': true }">
			<section class="toggle active">
				<aside class="aside bgcolortop">
				   <h3 class="aside-title">The Best state to visit in India</h3>
				</aside>
				<div class="toggle-content">
					<div class="panel-body"> 
						<div class="form-group">
						  <input type="text" value="" placeholder="Select Your City..." maxlength="100" class="form-control" name="name" required>
						</div>
					</div>
					<form role="form" action="https://www.exploreourindia.com/state" method="post" name="statewiselist" id="statewiselist">
					<input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
					<div class="panel-body"> 
						<div class="checkbox">
							<label style="font-size: 1em; margin-bottom:0px;">
								<input type="checkbox" name="stateid[]" value="10">
								<span class="cr"><i class="cr-icon fa fa-check"></i></span>
								Delhi
							</label>
						</div>
					</div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="46">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Goa
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="70">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Jammu & Kashmir
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="39">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Uttarakhand
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="49">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Himachal Pradesh
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="74">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Leh-Ladakh
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="55">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Manipur
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="62">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Sikkim
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="52">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Kerala
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="43">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Assam
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
						<input type="submit" class="btn btn-outline btn-secondary mb-2 mt-2" style="width:100%" value="Apply">
					</div>
				</form>
				<div class="panel-body"> 
				  <div class="checkbox">
					  <button id="myBtn1" class="morebtn">30 More</button>
					  <div id="myModal1" class="modal1">
							  <div class="col-lg-12">
							  <form role="form" action="https://www.exploreourindia.com/state" method="post" name="statewiselistALL" id="statewiselistALL">
							  <div class="modal1-content">
							  <span1 class="close1">&times;</span1>
							  <div class="row pb-1">
							  <div class="col-lg-12" style="margin:0px 0px;">
							  <h4>Select Your Destination</h4>
							  </div>
							  
								<input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
								<?php
								  $postAllState = State::find()->where(['status' => 1])->orderBy('state_name ASC')->all();
								  foreach($postAllState as $postAllStates) {
								?>
									<div class="col-lg-3" style="margin:1px 0px;">
										<div class="panel-body"> 
										  <div class="checkbox">
											<label style="font-size: 12px; margin:0px 0px;">
												<input type="checkbox" name="stateid[]" value="<?=$postAllStates->id?>">
												<span class="cr"><i class="cr-icon fa fa-check"></i></span>
												<?=$postAllStates->state_name?>
											</label>
											</div>
										</div>
									</div>
								  <?php } ?>
									<div class="col-lg-3" style="margin:1px 0px;">
										<div class="panel-body"> 
										  <div class="checkbox">
											<input type="submit" class="btn btn-outline btn-secondary mb-2 mt-2" style="width:100%" value="Apply">
										  </div> 
										</div>
									</div>
								
								</div>
							</div>
							</form>
						</div>
					</div>
				   </div> 
				 </div> 
					   
				</div>
			</section>							
		  </div>
		</div>
        <div class="hpanel panel-group sidebar" id="accordion" role="tablist" aria-multiselectable="true">
		  <aside class="aside bgcolortop">
			<h3 class="aside-title">Recent Blog</h3>
		  </aside>
			<ul class="simple-post-list">
			   <?php
               $recentBlog = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(5)->all();
			   foreach($recentBlog as $recentBlogg) {?>
				<li>
				  <article>
					<div class="post-image">
					  <div class="img-thumbnail img-thumbnail-no-borders d-block">
						<?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$recentBlogg->image.'" alt="'.$recentBlogg->heading.'" class="border-radius-0" width="50" height="50">', ['/blog/view', 'slug' => $recentBlogg->slug])?>
					  </div>
					</div>
					<div class="post-info">
					  <h4 class="font-weight-normal text-3 mb-0"><?=Html::a($recentBlogg->heading, ['/blog/view', 'slug' => $recentBlogg->slug])?></h4>
					  <p><?php echo $recentBlogg->limitTextWords(strip_tags($recentBlogg->content), 20, true, true);?></p>
					</div>
				  </article>
				</li>
				<?php } ?>  
			</ul>
         </div>
        </div> 
	</div>
</div>	
