<?php
use yii\helpers\Html;
use yii\widgets\ListView;
use yii\helpers\Url;
use yii\db\Query;
use backend\models\State;
use backend\models\Cricket;
/* @var $this yii\web\View */

$js = <<<JS
var modal1 = document.getElementById("myModal1");
var btn1 = document.getElementById("myBtn1");
var span1 = document.getElementsByClassName("close1")[0];
btn1.onclick = function() {
  modal1.style.display = "block";
}
span1.onclick = function() {
  modal1.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal1.style.display = "none";
  }
}
var modal = document.getElementById("myModal");
var btn = document.getElementById("myBtn");
var span = document.getElementsByClassName("close")[0];
btn.onclick = function() {
  modal.style.display = "block";
}
span.onclick = function() {
  modal.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
JS;
$this->registerJs($js);

$this->title = "Cricket";
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'Cricket',
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => 'Cricket',
]);
$ogimage = 'https://www.exploreourindia.com/frontend/web/images/logo.png';
$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => 'Cricket'], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => $ogimage], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => 'Cricket'], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => $ogimage], 'twitter:image');
?>
<div role="main" class="main">
    <section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
      <div class="container">
        <div class="row">
          <div class="col-md-12 align-self-left order-1">
            <ul class="breadcrumb d-block text-left">
              <li><?=Html::a("Home", ['/site/index'])?></li>
              <li class="active">Cricket</li>
            </ul>
          </div>
        </div>
      </div>
    </section>
<div class="container">
      <div class="row">
        <div class="col-lg-9 order-lg-1">
		  <div class="row pb-1">
		    <div class="col-lg-12">
		  <?=
                ListView::widget([
                    'dataProvider' => $catDataProvider,
                    'itemView' => '_blog',
                    'layout' => '{items}',
                    'emptyText' => "<div class='panel add_box'>
                                    <table class='table'>
                                        <div class='col-sm-12 text-center'>
                                            <img src='".Yii::$app->urlManagerFrontend->baseUrl.'/images/nodata.jpg'."' alt='Main Title Here'>
                                            <p2><br/><b>Available Soon !</b></p2>
                                        </div>            
                                    </table>
                                </div>",
                ])
                ?>
     
					<div class="prod_pagination">
								<div class="row">
									<div class="col-sm-4 result-pagi">
									   
									</div>
									<div class="col-sm-8 text-right">
										<?=
										ListView::widget([

											'dataProvider' => $catDataProvider,
											'layout' => '{pager}',
										])
										?> 
									</div>
								</div>
					</div> 
				</div>
			</div>
		</div>
		<div class="col-lg-3 mb-4 mb-lg-0 sidebar order-lg-2">  
        <div class="hpanel panel-group sidebar" id="accordion" role="tablist" aria-multiselectable="true">
		   <div class="toggle toggle-primary" data-plugin-toggle="" data-plugin-options="{ 'isAccordion': true }">
			<section class="toggle active">
				<aside class="aside bgcolortop">
				   <h3 class="aside-title">The Best state to visit in India</h3>
				</aside>
				<div class="toggle-content">
					<div class="panel-body"> 
						<div class="form-group">
						  <input type="text" value="" placeholder="Select Your City..." maxlength="100" class="form-control" name="name" required>
						</div>
					</div>
					<form role="form" action="https://www.exploreourindia.com/state" method="post" name="statewiselist" id="statewiselist">
					<input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
					<div class="panel-body"> 
						<div class="checkbox">
							<label style="font-size: 1em; margin-bottom:0px;">
								<input type="checkbox" name="stateid[]" value="10">
								<span class="cr"><i class="cr-icon fa fa-check"></i></span>
								Delhi
							</label>
						</div>
					</div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="46">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Goa
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="70">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Jammu & Kashmir
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="39">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Uttarakhand
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="49">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Himachal Pradesh
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="74">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Leh-Ladakh
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="55">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Manipur
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="62">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Sikkim
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="52">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Kerala
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="43">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Assam
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
						<input type="submit" class="btn btn-outline btn-secondary mb-2 mt-2" style="width:100%" value="Apply">
					</div>
				</form>
				<div class="panel-body"> 
				  <div class="checkbox">
					  <button id="myBtn1" class="morebtn">26 More</button>
					  <div id="myModal1" class="modal1">
							  <div class="col-lg-12">
							  <form role="form" action="https://www.exploreourindia.com/state" method="post" name="statewiselistALL" id="statewiselistALL">
							  <div class="modal1-content">
							  <span1 class="close1">&times;</span1>
							  <div class="row pb-1">
							  <div class="col-lg-12" style="margin:0px 0px;">
							  <h4>Select Your Destination</h4>
							  </div>
							  
								<input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
								<?php
								  $postAllState = State::find()->where(['status' => 1])->orderBy('state_name ASC')->all();
								  foreach($postAllState as $postAllStates) {
								?>
									<div class="col-lg-3" style="margin:1px 0px;">
										<div class="panel-body"> 
										  <div class="checkbox">
											<label style="font-size: 12px; margin:0px 0px;">
												<input type="checkbox" name="stateid[]" value="<?=$postAllStates->id?>">
												<span class="cr"><i class="cr-icon fa fa-check"></i></span>
												<?=$postAllStates->state_name?>
											</label>
											</div>
										</div>
									</div>
								  <?php } ?>
									<div class="col-lg-3" style="margin:1px 0px;">
										<div class="panel-body"> 
										  <div class="checkbox">
											<input type="submit" class="btn btn-outline btn-secondary mb-2 mt-2" style="width:100%" value="Apply">
										  </div> 
										</div>
									</div>
								
								</div>
							</div>
							</form>
						</div>
					</div>
				   </div> 
				 </div> 
					   
				</div>
			</section>							
		  </div>
		</div>
        <div >
       <!-- <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-3311269295796373"
     crossorigin="anonymous"></script>
<ins class="adsbygoogle"
     style="display:block"
     data-ad-client="ca-pub-3311269295796373"
     data-ad-slot="5817191787"
     data-ad-format="auto"
     data-full-width-responsive="true"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>-->
</div>
        <div class="hpanel panel-group sidebar" id="accordion" role="tablist" aria-multiselectable="true">
		  <aside class="aside bgcolortop">
			<h3 class="aside-title">Popular</h3>
		  </aside>
			<ul class="simple-post-list">
			    <?php
                foreach($popularBlog as $popularBlogg) {?>
				<li>
				  <article>
					<div class="post-image">
					  <div class="img-thumbnail img-thumbnail-no-borders d-block">
						<?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/cricket/'.$popularBlogg->image.'" alt="'.$popularBlogg->heading.'" class="border-radius-0" width="80" height="45">', ['/cricket/view', 'slug' => $popularBlogg->slug])?>
					  </div>
					</div>
					<div class="post-info">
					  <h4 class="font-weight-normal text-3 mb-0"><?=Html::a($popularBlogg->heading, ['/cricket/view', 'slug' => $popularBlogg->slug])?></h4>
					  <p><?php echo $popularBlogg->limitTextWords(strip_tags($popularBlogg->content), 20, true, true);?></p>
					</div>
				  </article>
				</li>
				<?php } ?>  
			</ul>
         </div>
         
        </div>
	</div>
</div>	
