<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;
use common\widgets\Alert;
use yii\helpers\Url;
use frontend\assets\AppAsset;

AppAsset::register($this);

$this->title = 'Contact Us - Explore Our India';
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'Contact Us',
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => 'Contact Us',
]);
$this->params['breadcrumbs'][] = $this->title;
$ogimage = 'https://www.exploreourindia.com/frontend/web/images/logo.png';
$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => 'Contact Us'], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => $ogimage], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => 'Contact Us'], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => $ogimage], 'twitter:image');
?>

<section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
  <div class="container">
	<div class="row">
	  <div class="col-md-12 align-self-left order-1">
		<ul class="breadcrumb d-block text-left">
		  <li><?=Html::a('Home', ['/site/index'])?></li>
		  <li class="active">Contact us</li>
		</ul>
	  </div>
	</div>
  </div>
</section>
<div class="container">
	<div class="row py-4">
		<div class="col-lg-6">
			<div class="overflow-hidden mb-1">
				<h2 class="font-weight-normal text-7 mt-2 mb-0 appear-animation animated maskUp appear-animation-visible" data-appear-animation="maskUp" data-appear-animation-delay="200" style="animation-delay: 200ms;"><strong class="font-weight-extra-bold">Contact</strong> Us</h2>
			</div>
			<div class="overflow-hidden mb-4 pb-3">
				<p class="mb-0 appear-animation animated maskUp appear-animation-visible" data-appear-animation="maskUp" data-appear-animation-delay="400" style="animation-delay: 400ms;">Don't keep any questions.</p>
			</div>
<?php if(Yii::$app->session->getFlash('copmssg') != '') { ?>
								<div class="contact-form-success alert alert-success d-none mt-4">
									<strong>Success!</strong> Your message has been sent to us.
								</div>
							<?php } ?>
							<?php if(Yii::$app->session->getFlash('copmsgerror') != '') {?>
								<div class="contact-form-error alert alert-danger d-none mt-4">
									<strong>Error!</strong> There was an error sending your message.
									<span class="mail-error-message text-1 d-block"></span>
								</div>
							<?php } ?>
			<?php $form = ActiveForm::begin(['options' => [
				'class' => 'contact-form',
			 ],
			'fieldConfig' => [
					'template' => "{label}{input}{error}",
				],
			]); ?>
			<?= $form->field($model, 'name')->textInput(['placeholder' => $model->getAttributeLabel('name')]) ?>
			<?= $form->field($model, 'email')->textInput(['placeholder' => $model->getAttributeLabel('email')]) ?>
			<?= $form->field($model, 'contact_no')->textInput(['placeholder' => $model->getAttributeLabel('contact_no')]) ?>
			<?= $form->field($model, 'message')->textArea(['placeholder' => 'Your Message Here...']) ?>
			<?= $form->field($model, 'reCaptcha')->widget(
                            \himiklab\yii2\recaptcha\ReCaptcha2::className(),
                            [
                                'siteKey' => '6Le9yTAmAAAAAH99_AET8KniQphvzMEoChTT_yoY', // unnecessary is reCaptcha component was set up
                            ]
                        )->label(false) ?>
			<?= Html::submitButton(Yii::t('user', 'Send Message'), ['class' => 'btn btn-primary btn-modern']) ?>
	   <?php ActiveForm::end(); ?>
		</div>
		<div class="col-lg-5">
			<div class="overflow-hidden mb-1">
				<h4 class="text-primary mb-0 appear-animation animated maskUp appear-animation-visible" data-appear-animation="maskUp" data-appear-animation-delay="200" style="animation-delay: 200ms;">Get in <strong>Touch</strong></h4>
			</div>
			<div class="overflow-hidden mb-3">
				<p class="lead text-4 mb-0 appear-animation animated maskUp appear-animation-visible" data-appear-animation="maskUp" data-appear-animation-delay="400" style="animation-delay: 400ms;">If you have any query regarding any tourist place in India or if you want to book any package, then please feel free to contact us.</p>
			</div>
			<div class="appear-animation animated fadeInUpShorter appear-animation-visible" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="800" style="animation-delay: 800ms;">
				<h4 class="text-primary pt-5">Our <strong>Office</strong></h4>
				<ul class="list list-icons list-icons-style-3 mt-2">
					<li><i class="fas fa-map-marker-alt top-6"></i> <strong>Address:</strong> 201301, Sector 2 Noida, Gautam Budh Nagar (U.P.) </li>
					<li><i class="fas fa-envelope top-6"></i> <strong>Email:</strong> <a href="exploreourindia21@gmail.com">exploreourindia21@gmail.com</a></li>
				</ul>
				

				<h4 class="text-primary pt-5">Business <strong>Hours</strong></h4>
				<ul class="list list-icons list-dark mt-2">
					<li><i class="far fa-clock top-6"></i> Monday - Friday - 9am to 5pm</li>
					<li><i class="far fa-clock top-6"></i> Saturday - 9am to 2pm</li>
					<li><i class="far fa-clock top-6"></i> Sunday - Closed</li>
				</ul>
			</div>
		</div>
	</div>
</div>
