<?php
use yii\helpers\Html;
use yii\widgets\ListView;
use yii\helpers\Url;
use yii\db\Query;
use backend\models\State;
use backend\models\Blog;
use backend\models\City;
/* @var $this yii\web\View */

$this->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', ['position' => \yii\web\View::POS_HEAD]);
$this->registerJsFile('http://localhost/ourindia/frontend/web/js/modernizr.min.js', ['position' => \yii\web\View::POS_HEAD]);

$js = <<<JS
   $(document).on('click', '.buttonmodalquery',function(){ 
		$('#popup').modal('show')
		 .find('#askquery')
		 .load($(this).attr('value'));
	});
JS;
$this->registerJs($js);

$js = <<<JS
document.getElementById("toggleBtn").addEventListener("click", function () { 
    document.getElementById("shortrd").style.display = "none";
	document.getElementById("longrd").style.display = "block";
});

var modal1 = document.getElementById("myModal1");
var btn1 = document.getElementById("myBtn1");
var span1 = document.getElementsByClassName("close1")[0];
btn1.onclick = function() {
  modal1.style.display = "block";
}
span1.onclick = function() {
  modal1.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal1.style.display = "none";
  }
}
var modal = document.getElementById("myModal");
var btn = document.getElementById("myBtn");
var span = document.getElementsByClassName("close")[0];
btn.onclick = function() {
  modal.style.display = "block";
}
span.onclick = function() {
  modal.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
JS;
$this->registerJs($js);

$this->title = $model->meta_title;
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => $model->meta_description,
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => $model->meta_keyword,
]);
$ogimage = 'https://www.exploreourindia.com/frontend/web/images/logo.png';
$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => $model->meta_description], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => $ogimage], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => $model->meta_description], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => $ogimage], 'twitter:image');
?>
<style>
	.boxnv{ border: 1px solid #ccc;
	border-radius: 5px;
	padding-left: 0px;
	text-align: center;}                  
</style>
<div role="main" class="main">
    <section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
      <div class="container">
        <div class="row">
          <div class="col-md-12 align-self-left order-1">
            <ul class="breadcrumb d-block text-left">
              <li><?=Html::a("Home", ['/site/index'])?></li>
              <li class="active"><?php echo $model->name?></li>
            </ul>
          </div>
        </div>
      </div>
    </section>
<div class="container">
      <div class="row">
	   <div class="col-lg-9 order-lg-1">
           <h2 class="font-weight-bolder line-height-1 gradient-text-color"> 

            <span class="line1 text-7 pb-1"> <?php echo $model->name?></span>
         	   
          </h2>
          <div class="blog-posts mt-0">
            <article class="post post-large">
              <div class="post-content mrgnlfta">
			   <?php if(isset($model->introduction)) {?>
			   <div class="intro" id="shortrd">
                <?php echo $model->limitTextWords(strip_tags($model->introduction), 75, true, true);?>
                 <span class="mb-1 pb-1">
                  <button type="button" id="toggleBtn" class="btn btn-rounded btn-gradient mb-2 font-weight-bold float-right">Read More</button>
                 </span>
                </div>
                <?php } ?>
                <div class="intro" id="longrd" style="display:none;"><?=$model->introduction?></div>                
              </div>
            </article>
          </div>
           <hr class="pattern pattern-2 tall mt-0 mb-4">
		   <div class="row pb-4 mt-3">
            <div class="col">
            <h2 class="font-weight-bold text-8 line-height-2 gradient-text-color mt-1 mb-3">Select Your State – Begin Your Pilgrimage Journey</h2>
              <div class="appear-animation animated fadeIn appear-animation-visible" data-appear-animation="fadeIn" data-appear-animation-delay="500" style="animation-delay: 500ms;">
			   <div class="owl-carousel owl-theme stage-margin rounded-nav owl-loaded owl-drag owl-carousel-init" data-plugin-options="{'autoWidth': false,'margin': 10, 'items': 5, 'loop': false, 'nav': true, 'dots': false, 'stagePadding': 40}" style="height: auto;">
					<ul class="nav nav-pills sort-source sort-source-style-3" data-sort-id="portfolio" data-option-key="filter" data-plugin-options="{'layoutMode': 'masonry', 'filter': '.delhi'}">
                      <div class="owl-stage-outer">
                        <div class="owl-stage" style="transform: translate3d(-352px, 0px, 0px); transition: all 0.25s ease 0s;width: 1490px;  padding-left: 40px; padding-right: 40px;">
                        <?php $StateQuery = backend\models\State::find()->where(['status' => 1])->orderBy(['id' => SORT_ASC])->all();
		        $i=1;foreach($StateQuery as $StateQuerylist) {
					?>
                          <div class="owl-item"><div>
									<li class="nav-item boxnv <?php if($i == 1) {?>active<?php } ?>" data-option-value=".<?=$StateQuerylist->slug?>"><a class="nav-link text-1 text-uppercase <?php if($i == 1) {?>active<?php } ?>" style="padding: .5rem .5rem;" href="#"><?=$StateQuerylist->state_name?></a></li>
								</div></div>
                                 <?php $i++; } ?>                           
                             </div>
                          </div>                                
                       </ul>                                
                     
                 </div>
               
			   <div class="sort-destination-loader mt-4 pt-2 sort-destination-loader-loaded">
                  <div class="row portfolio-list sort-destination" data-sort-id="portfolio" data-filter=".delhi">                    
				  <?php 
		        $j=1;foreach($StateQuery as $postsQuery) {?>
				<?php $postQueryy = backend\models\Post::find()->where(['status' => 1])->andwhere(['state_id' => $postsQuery->id])->andwhere(['category_id' => $model->id])->orderBy(['id' => SORT_ASC])->limit(8)->all();
		               if(count($postQueryy) != '') {
						   foreach($postQueryy as $postallQuery) {?>
					<div class="col-12 col-sm-6 col-lg-3 isotope-item marketing <?=$postsQuery->slug?>">
					  <span class="thumb-info thumb-info-hide-wrapper-bg mb-4">
					    <span class="thumb-info-wrapper">
						<?php if($postallQuery->image != '') {?>
						   <?= Html::a("<img src='".Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$postallQuery->image."' class='img-fluid' alt='".$postallQuery->title."'>",['/post/view/', 'slug' => $postallQuery->slug])  ?>
						<?php } else { ?>
						  <?= Html::a("<img src='".Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg'."' class='img-fluid' alt='".$postallQuery->title."'>",['/post/view/', 'slug' => $postallQuery->slug])  ?>
						<?php } ?>
						</span>
						<span class="thumb-info-caption ">
                      <h4 class="gradient-text-color font-weight-semibold text-3 line-height-6 mt-2 mb-2">
					    <?=Html::a($postallQuery->title, ['/post/view', 'slug' => $postallQuery->slug])?>    
					   </h4>
                      <span>
                      <?php 
						  echo Html::button('Explore Now', [
								'class' => 'btn btn-rounded btn-gradient mb-2 font-weight-bold',
								'style' => 'width:100%',
								'onclick' => "window.location.href='" . \yii\helpers\Url::to(['/post/view', 'slug' => $postallQuery->slug]) . "'"
							]);

						?>
                      </span> </span> </span>
					</div>
				<?php } } ?>
                   <div class="col-12 col-sm-12 col-lg-12 isotope-item marketing <?=$postsQuery->slug?>"><span class="thumb-info thumb-info-hide-wrapper-bg mb-4"><span class="thumb-info-caption "><span>
                      <?php 
						  echo Html::button('Explore More Temples in '.$postsQuery->state_name, [
								'class' => 'btn btn-rounded btn-gradient mb-2 w-100 font-weight-bold',
								'onclick' => "window.location.href='" . \yii\helpers\Url::to(['/state/view', 'slug' => $postsQuery->slug]) . "'"
							]);

						?>
                      </span></span></span></div>
				<?php $j++; } ?>				
				  </div>                  
                </div>
              </div>
            </div>
          </div>
		  
		  <section class="section bg-color-dark-scale-1  section-height-1 border-0 m-0 mt-2">
    <div class="container  py-3">
    <div class="heading heading-border heading-middle-border text-center "> 
            <h2 class="font-weight-bold"> Next Destination Across Incredible India </h2>
          </div>
      <div class="row">    
         <div class="owl-carousel owl-theme stage-margin owl-loaded owl-drag owl-carousel-init" data-plugin-options="{'items': 5, 'autoplay': true, 'autoplayTimeout': 4000, 'margin': 10, 'loop': true, 'nav': true, 'dots': false, 'stagePadding': 40}" style="height: auto;">
			<div class="owl-stage-outer"><div class="owl-stage" style="transform: translate3d(0px, 0px, 0px); transition: all 0.25s ease 0s; width: 1814px; padding-left: 40px; padding-right: 40px;">
			<?php
             $stateQuery = backend\models\State::find()->where(['status' => 1])->orderBy(['id' => SORT_ASC])->all();
			foreach($stateQuery as $modelstateall) {?>
			<div class="owl-item active" style="width: 163.333px; margin-right: 10px;">
			  <div>
				<?php if($modelstateall->image != '') {?>
				   <?= Html::a("<img src='".Yii::$app->urlManagerBackend->baseUrl.'/images/state/'.$modelstateall->image."' alt='".$modelstateall->state_name."' class='img-fluid rounded mb-2'>",['/state/view/', 'slug' => $modelstateall->slug])  ?>
				<?php } else { ?>
				  <?= Html::a("<img src='".Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg'."' alt='".$modelstateall->state_name."' class='img-fluid rounded mb-2'>",['/state/view/', 'slug' => $modelstateall->slug])  ?>
				<?php } ?>
					<span>
					   <?php 
						  echo Html::button($modelstateall->state_name, [
								'class' => 'btn btn-rounded full-width btn-gradient mb-2 font-weight-bold',
								'style' => 'width:100%',
								'onclick' => "window.location.href='" . \yii\helpers\Url::to(['/state/view', 'slug' => $modelstateall->slug]) . "'"
							]);

						?>
					</span>
				</div>
			 </div>
			<?php } ?></div></div>	
		</div>         
      </div>
      <div class="row">
        <div class="col text-center"><?=Html::a('VIEW ALL STATES IN INDIA', ['/state/index'], ['class' => 'btn btn-primary font-weight-semibold text-3 px-5 btn-py-2'])?></div>
      </div>
    </div>
  </section>
		  
		  <section class="section border-0 mt-3 pb-0 pt-2">
			<div class="container">
			  <div class="row pb-1 pt-1">
				<div class="heading heading-border text-center mt-2 mb-2 pb-3">
				  <h3 class="text-4 gradient-text-color "><strong class="font-weight-bold text-10 text-light px-3 py-3 line-height-1 ">Best Places to Visit Incredible India</strong></h3>
				</div>
				<?php 
					 $relatedpost = backend\models\Post::find()->where(['category_id' => $model->id])->andwhere(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(9)->all();
					 if(count($relatedpost) != '') {
						 foreach($relatedpost as $relatedposts) {?>
				  <div class="col-sm-6 col-lg-4 mb-4 pb-2">
					 <?php if($relatedposts->image != '') {?>
							<?=Html::a('<article><div class="thumb-info thumb-info-no-borders thumb-info-bottom-info thumb-info-bottom-info-dark thumb-info-bottom-info-show-more thumb-info-no-zoom border-radius-0"><div class="thumb-info-wrapper thumb-info-wrapper-opacity-3"><img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$relatedposts->image.'" alt="'.$relatedposts->title.'" class="img-fluid border-radius-0"><div class="thumb-info-title bg-transparent p-4"></div></div><h4 class="line-height-2 text-4 font-weight-bold mb-0 p-2">'.$relatedposts->title.', '.$relatedposts->state->state_name.'</h4></div></article>', ['/post/view', 'slug' => $relatedposts->slug])?>  
						  <?php } else { ?>
						   <?=Html::a('<article><div class="thumb-info thumb-info-no-borders thumb-info-bottom-info thumb-info-bottom-info-dark thumb-info-bottom-info-show-more thumb-info-no-zoom border-radius-0"><div class="thumb-info-wrapper thumb-info-wrapper-opacity-3"><img src="/images/photo-not-availabe.jpg" alt="'.$relatedposts->title.'" class="img-fluid border-radius-0"><div class="thumb-info-title bg-transparent p-4"></div></div><h4 class="line-height-2 text-4 font-weight-bold mb-0 p-2">'.$relatedposts->title.', '.$relatedposts->state->state_name.'</h4></div></article>', ['/post/view', 'slug' => $relatedposts->slug])?>  
						  <?php } ?>
				  </div>
					<?php }} ?>
				 </div>
			 </div>
		  </section>
		  
		 </div>  
        
		<div class="col-lg-3 mb-4 mb-lg-0 sidebar order-lg-2">  
        <div class="hpanel panel-group sidebar" id="accordion" role="tablist" aria-multiselectable="true">
		   <div class="toggle toggle-primary" data-plugin-toggle="" data-plugin-options="{ 'isAccordion': true }">
			<section class="toggle active">
				<aside class="aside bgcolortop">
				   <h3 class="aside-title">The Best state to visit in India</h3>
				</aside>
				<div class="toggle-content">
					<div class="panel-body"> 
						<div class="form-group">
						  <input type="text" value="" placeholder="Select Your City..." maxlength="100" class="form-control" name="name" required>
						</div>
					</div>
					<form role="form" action="https://www.exploreourindia.com/state" method="post" name="statewiselist" id="statewiselist">
					<input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
					<div class="panel-body"> 
						<div class="checkbox">
							<label style="font-size: 1em; margin-bottom:0px;">
								<input type="checkbox" name="stateid[]" value="10">
								<span class="cr"><i class="cr-icon fa fa-check"></i></span>
								Delhi
							</label>
						</div>
					</div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="46">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Goa
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="70">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Jammu & Kashmir
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="39">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Uttarakhand
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="49">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Himachal Pradesh
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="74">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Leh-Ladakh
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="55">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Manipur
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="62">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Sikkim
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="52">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Kerala
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
					  <div class="checkbox">
						<label style="font-size: 1em; margin-bottom:0px;">
							<input type="checkbox" name="stateid[]" value="43">
							<span class="cr"><i class="cr-icon fa fa-check"></i></span>
							Assam
						</label>
					</div>  </div>
					
					<div class="panel-body"> 
						<input type="submit" class="btn btn-outline btn-secondary mb-2 mt-2" style="width:100%" value="Apply">
					</div>
				</form>
				<div class="panel-body"> 
				  <div class="checkbox">
					  <button id="myBtn1" class="morebtn">26 More</button>
					  <div id="myModal1" class="modal1">
							  <div class="col-lg-12">
							  <form role="form" action="https://www.exploreourindia.com/state" method="post" name="statewiselistALL" id="statewiselistALL">
							  <div class="modal1-content">
							  <span1 class="close1">&times;</span1>
							  <div class="row pb-1">
							  <div class="col-lg-12" style="margin:0px 0px;">
							  <h4>Select Your Destination</h4>
							  </div>
							  
								<input type="hidden" name="_csrf" value="<?= Yii::$app->request->getCsrfToken() ?>" />
								<?php
								  $postAllState = State::find()->where(['status' => 1])->orderBy('state_name ASC')->all();
								  foreach($postAllState as $postAllStates) {
								?>
									<div class="col-lg-3" style="margin:1px 0px;">
										<div class="panel-body"> 
										  <div class="checkbox">
											<label style="font-size: 12px; margin:0px 0px;">
												<input type="checkbox" name="stateid[]" value="<?=$postAllStates->id?>">
												<span class="cr"><i class="cr-icon fa fa-check"></i></span>
												<?=$postAllStates->state_name?>
											</label>
											</div>
										</div>
									</div>
								  <?php } ?>
									<div class="col-lg-3" style="margin:1px 0px;">
										<div class="panel-body"> 
										  <div class="checkbox">
											<input type="submit" class="btn btn-outline btn-secondary mb-2 mt-2" style="width:100%" value="Apply">
										  </div> 
										</div>
									</div>
								
								</div>
							</div>
							</form>
						</div>
					</div>
				   </div> 
				 </div> 
					   
				</div>
			</section>							
		  </div>
		</div>
        <div >
     <!--   <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-3311269295796373"
     crossorigin="anonymous"></script>
        <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-3311269295796373"
     crossorigin="anonymous"></script>

<ins class="adsbygoogle"
     style="display:block"
     data-ad-client="ca-pub-3311269295796373"
     data-ad-slot="5817191787"
     data-ad-format="auto"
     data-full-width-responsive="true"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>-->
</div>
        <div class="hpanel panel-group sidebar" id="accordion" role="tablist" aria-multiselectable="true">
		  <aside class="aside bgcolortop">
			<h3 class="aside-title">Recent Blog</h3>
		  </aside>
			<ul class="simple-post-list">
			   <?php
               $recentBlog = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(5)->all();
			   foreach($recentBlog as $recentBlogg) {?>
				<li>
				  <article>
					<div class="post-image">
					  <div class="img-thumbnail img-thumbnail-no-borders d-block">
						<?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$recentBlogg->image.'" alt="'.$recentBlogg->heading.'" class="border-radius-0" width="90" height="50">', ['/blog/view', 'slug' => $recentBlogg->slug])?>
					  </div>
					</div>
					<div class="post-info">
					  <h4 class="font-weight-normal text-3 mb-0"><?=Html::a($recentBlogg->heading, ['/blog/view', 'slug' => $recentBlogg->slug])?></h4>
					  <p><?php echo $recentBlogg->limitTextWords(strip_tags($recentBlogg->content), 20, true, true);?></p>
					</div>
				  </article>
				</li>
				<?php } ?>  
			</ul>
         </div>
         <div >
        <!--<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-3311269295796373"
     crossorigin="anonymous"></script>

<ins class="adsbygoogle"
     style="display:block"
     data-ad-client="ca-pub-3311269295796373"
     data-ad-slot="5817191787"
     data-ad-format="auto"
     data-full-width-responsive="true"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>-->
</div>
        </div>
	</div>
</div>	
<section class="section bg-color-primary border-0 m-0">
      <div class="container container-lg">
        <div class="row">
          <div class="col text-center">
            <div class="owl-carousel owl-theme nav-dark stage-margin nav-style-1 m-0 owl-loaded owl-drag owl-carousel-init" data-plugin-options="{'items': 6, 'autoplay': true, 'autoplayTimeout': 3000, 'margin': 5, 'loop': true, 'nav': true, 'dots': false, 'stagePadding': 40}" style="height: auto;">
              <div class="owl-stage-outer">
                <div class="owl-stage" style="transform: translate3d(-1557px, 0px, 0px); transition: all 0.25s ease 0s; width: 2973px; padding-left: 40px; padding-right: 40px;">
                  <?php
					  $postAllstates = State::find()->where(['status' => 1])->orderBy('state_name ASC')->all();
					  foreach($postAllstates as $postAllstatees) {
					?>
				  <div class="owl-item">
                    <div class="px-3">
					  <?=Html::a($postAllstatees->state_name, ['/state/view', 'slug' => $postAllstatees->slug], ['class' => 'btn btn-dark btn-block py-3 rounded-0 text-2 font-weight-bold'])?>
					</div>
                  </div>
				<?php } ?>
                </div>
              </div>
              <div class="owl-nav">
                <button type="button" role="presentation" class="owl-prev"></button>
                <button type="button" role="presentation" class="owl-next disabled"></button>
              </div>
              <div class="owl-dots disabled"></div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="call-to-action call-to-action-default with-button-arrow content-align-center call-to-action-in-footer call-to-action-in-footer-margin-top mt-2 pt-4" style="background:#ff671f">
      <div class="container">
        <div class="row">
          <div class="col-md-9 col-lg-9">
            <div class="col-md-12 col-lg-11">
              <div class="call-to-action-content">
                <h4 class="word-rotator slide font-weight-bold text-7 mb-2 appear-animation animated fadeInUpShorter appear-animation-visible" data-appear-animation="fadeInUpShorter" style="animation-delay: 100ms;"><span class="pb-3"><i class="fas fa-quote-left "></i> Your Story, Our Inspiration <i class="fas fa-quote-right"></i></span><br>
                  <span>Share Your Travel </span> <span class="word-rotator-words bg-dark"> <b class="is-visible">Story</b> <b class="is-hidden">Journey</b> <b class="is-hidden">Experience</b> <b class="is-hidden">Adventure</b> <b class="is-hidden">Memories</b> <b class="is-hidden">Exploration</b> </span> <span> – Inspire Fellow Explorers </span> </h4>
                <p class="mb-0 text-color-light p-3 text-3 line-height-5"> Travel is more than just visiting destinations it’s about the journeys, experiences, and memories we create along the way. From breathtaking landscapes to cultural encounters, your travel experiences can inspire fellow explorers to embark on their own adventures. Share your travel story and let the world see the magic through your eyes.</p>
              </div>
            </div>
          </div>
          <div class="col-md-3 col-lg-3">
            <div class="call-to-action-btn">
              <?=Html::a('Share Your Travel Story', FALSE, ['value' => Url::to(['/site/sharestories']), 'class' => 'open-btn btn btn-dark btn-lg text-3 font-weight-semibold px-4 py-3 buttonmodalquery', 'title' => 'Share Your Travel Story']);?>
              <span class="arrow hlb d-none d-md-block appear-animation animated rotateInUpLeft appear-animation-visible" data-appear-animation="rotateInUpLeft" style="top: -40px; left: 70%; animation-delay: 100ms;"></span></div>
          </div>
        </div>
      </div>
    </section>
    <section class="section section-height-3 bg-color-grey-scale-1 border-0 m-0 appear-animation animated fadeIn appear-animation-visible" data-appear-animation="fadeIn" style="animation-delay: 100ms;">
      <div class="container">
        <h3 class="text-4 gradient-text-color text-center"><strong class="font-weight-bold text-10 text-light px-3 py-2 line-height-1 "><i class="fas fa-quote-left"></i> What Our Travelers Say <i class="fas fa-quote-right"></i></strong></h3>
        <p class="text-center text-7 font-weight-bold alternative-font"><i>Real reviews and experiences from happy explorers across India & beyond.</i></p>
        <div class="row">
          <div class="col appear-animation animated fadeInUpShorter appear-animation-visible" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="200" style="animation-delay: 200ms;">
            <div class="owl-carousel owl-theme stage-margin stage-margin-lg nav-dark nav-style-2 mb-0 owl-loaded owl-drag owl-carousel-init" data-plugin-options="{'items': 1, 'margin': 100, 'loop': false, 'nav': true, 'dots': false, 'stagePadding': 100, 'autoHeight': true}" style="height: auto;">
              <div class="owl-stage-outer owl-height" style="height: 274.112px;">
                <div class="owl-stage" style="transform: translate3d(0px, 0px, 0px); transition: all 0.25s ease 0s; width: 2220px; padding-left: 100px; padding-right: 100px;">
                  <?php $i=1;
				 foreach($travelstory as $travelstories) {
				?>
				<div class="owl-item <?php if($i == 1) {?>active<?php } ?>" style="width: 910px; margin-right: 100px;">
                  <div>
                    <div class="testimonial testimonial-style-2 mb-0">
                      <div class="testimonial-author"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/tarvel-story-img/<?=$travelstories->img?>" alt="<?=$travelstories->name?>"> </div>
                      <blockquote>
                        <p class="text-color-dark text-5 line-height-5 mb-0"><?=$travelstories->message?></p>
                      </blockquote>
                      <div class="testimonial-author">
                        <p><strong class="font-weight-extra-bold text-2">- <?=$travelstories->name?></strong></p>
                      </div>
                    </div>
                  </div>
                </div>
				<?php $i++; } ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
	<div class="container ">
      <div class="row ">
        <div class="col-lg-12 order-lg-1" style="background:#FFF; box-shadow:0px 0px 3px #bbbbbb; border-radius:10px;float:left;">      
			<div class="heading heading-border heading-middle-border mt-4" >
				<h3 class="text-5"><strong class="text-1 px-3 text-light py-2 bg-quaternary">More Tourist Destination</strong></h3>
			</div>		   
		   <div class="blog-posts mb-5">
			   <?php
				 $postQQuery = backend\models\Post::find()->where(['status' => 1])->andwhere(['category_id' => $model->id])->orderBy(['id' => SORT_ASC])->limit(20)->all();
				if(count($postQQuery) != '') {
			   ?>
			<div class="heading heading-border heading-middle-border heading-middle-border-center heading-border-lg">
				<h2 class="font-weight-normal text-5"><?php echo ucfirst($model->name)?></h2>
			</div>
			<div class="row pb-1">
				<div class="col-sm-12">
					<?php 
						 foreach($postQQuery as $postallQueryy) {
					  ?>
					 <?=Html::a($postallQueryy->title, ['/post/view', 'slug' => $postallQueryy->slug], ['class' => 'btn btn-outline btn-rounded btn-secondary mb-2'])?>    
					 <?php } ?>
				</div>
			</div>
	    <?php } ?>
         </div>
		</div>
      </div>
    </div>
  </div>