<?php
namespace frontend\models;

use Yii;
use yii\helpers\Html;
use yii\base\Model;
use \yii\db\Expression;

/**
 * This is the model class for table "contact_us".
 *
 * @property integer $id
 * @property string $name
 * @property string $email
 * @property string $contact_no
 * @property string $message
 * @property string $create_on
 * @property string $update_on
 * @property integer $status
 */
class ShareYourTravelStory extends \yii\db\ActiveRecord {
    /**
     * @inheritdoc
     */  
   
   public static function tableName()
    {
        return 'share_your_travel_story';
    }

    /**
     * @inheritdoc
     */

    public function rules() {
        return [
            [['name', 'email', 'contact_no', 'message'], 'required'],
            [['message'], 'string'],
            [['create_on', 'update_on', 'img'], 'safe'],
            [['contact_no', 'status'], 'integer'],
            [['name'], 'string', 'max' => 100],
            [['email'], 'string', 'max' => 50],
            [['contact_no'], 'string', 'min' => '10', 'max' => 10],
            ['email', 'email'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'email' => 'Email',
            'Mobile' => 'Contact No',
            'img' => 'Image',
            'message' => 'Message',
	   'create_on' => 'Create On',
            'update_on' => 'Update On',
            'status' => 'Status',
        ];
    }
	
   public function beforeSave($insert) {

        if ($this->isNewRecord) {
            $this->create_on = new Expression('NOW()');
        } else {
            $this->update_on = new Expression('NOW()');
        }
        if (isset($this->name) && $this->name != '') {
            $this->name = ucwords($this->name);
        }

        return parent::beforeSave($insert);
    }

}
