<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\Story;
use backend\models\Substory;
use yii\helpers\Url;

class StoryController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'view'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }

	
	public function actionIndex() {
	    $this->layout = false;
		$storyQuery = Story::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->all();
		 return $this->render('index', [
                    'storyQuery' => $storyQuery,
             ]);
		
	}

	
	public function actionView($slug) {
	    $this->layout = false;
		$postQueryy = Story::find()->where(['slug' => $slug, 'status' => 1])->one();
		if(isset($postQueryy)) {
		  $postQuery = Story::find()->where(['slug' => $slug, 'status' => 1])->one();
		  $storysubQuery = Substory::find()->where(['story_id' => $postQuery->id, 'status' => 1])->orderBy(['id' => SORT_ASC])->all();
if(count($storysubQuery) != '') {
		 return $this->render('view', [
                    'storyQuery' => $postQuery,
					'storysubQuery' => $storysubQuery
             ]);
} else {
return $this->redirect(Yii::$app->request->referrer);
}
	
        } else {
			throw new NotFoundHttpException('The requested page does not exist.');
		}		
	}	 
}
