<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\Movie;
use backend\models\MovieCategory;
use frontend\models\MovieComments;
use yii\helpers\Url;

class MovieController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'view'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }
	
	public function actionIndex() {
     	$caQuery = Movie::find()->where(['status' => 1]);
		$catDataProvider = new ActiveDataProvider([

            'query' => $caQuery,
            'sort' => [
                'defaultOrder' => [
                    'id' => SORT_DESC,
                ]
            ],
            'pagination' => [
                'pageSize' => 10,
        ]]);
		$popularBlog = Movie::find()->where(['status' => 1])->orderBy(['blog_view' => SORT_DESC])->limit(10)->all();
		return $this->render('index', [
					'catDataProvider' => $catDataProvider,
					'popularBlog' => $popularBlog,
		]);
    }
	
	public function actionView($slug) {
	    $this->layout = 'blog';
		$modelcomment = new MovieComments();
		$postQueryy = Movie::find()->where(['slug' => $slug, 'status' => 1])->one();
		if(isset($postQueryy)) {
		$totalview = ($postQueryy->blog_view + 1);
$connection = Yii::$app->db;
			$command = $connection->createCommand()->update('movie', ['blog_view' => $totalview], ['status' => 1, 'id' => $postQueryy->id])->execute();
			$connection->close();
		$postQuery = Movie::find()->where(['slug' => $slug, 'status' => 1])->one();
		 $relatedBlog = Movie::find()->where(['cat_id' => $postQuery->cat_id, 'status' => 1])->AndWhere(['!=', 'id', $postQuery->id])->orderBy(['id' => SORT_DESC])->limit(5)->all();
		 $recentBlog = Movie::find()->where(['status' => 1])->AndWhere(['!=', 'id', $postQuery->id])->orderBy(['id' => SORT_DESC])->limit(5)->all();
		 $popularBlog = Movie::find()->where(['status' => 1])->orderBy(['blog_view' => SORT_DESC])->limit(10)->all();
		 $count_all = MovieComments::find()->where(['status' => 1])->andwhere(['movie_id' => $postQuery->id])->all();
		 $comments_all = MovieComments::find()->where(['status' => 1])->andwhere(['parent_id' => 0])->andwhere(['movie_id' => $postQuery->id])->orderBy(['id' => SORT_DESC])->all();
		 if ($modelcomment->load(Yii::$app->request->post())) {
	             Yii::$app->getSession()->destroy();
			if (Yii::$app->request->isAjax) {
				Yii::$app->response->format = Response::FORMAT_JSON;
				return ActiveForm::validate($modelcomment);
			}
			
			$modelcomment->movie_id = $postQuery->id;
		  if($modelcomment->save(false)) {
            \Yii::$app->getSession()->setFlash('copmssg', 'Your Comment will only be visible after moderation!');
			return $this->redirect(Yii::$app->request->referrer);
		  } else {
             \Yii::$app->getSession()->setFlash('copmssgerror', 'Unable to add your Comment.');
			 return $this->redirect(Yii::$app->request->referrer); 
		  }
		} else {
		 return $this->render('view', [
                    'postQuery' => $postQuery,
					'relatedBlog' => $relatedBlog,
					'recentBlog' => $recentBlog,
					'popularBlog' => $popularBlog,
					'modelcomment' => $modelcomment,
					'count_all' => $count_all,
					'commentalls' => $comments_all,
             ]);
		}	
        } else {
			throw new NotFoundHttpException('The requested page does not exist.');
		 }		
	}		 
}
