<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\FamousPlaces;
use backend\models\Blog;

class FamousPlacesController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'view'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }

    public function actionIndex() {
     	 $postQuery = FamousPlaces::find()->where(['status' => 1])->all();
		 return $this->render('index', [
                    'postQuery' => $postQuery,
             ]);
    }
	
	public function actionView($slug) {
		 $postQuery = FamousPlaces::find()->where(['slug' => $slug, 'status' => 1])->one();
                 if(isset($postQuery)) {
$recentBlog = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(5)->all();
return $this->render('view', [
                    'postQuery' => $postQuery,
'recentBlog' => $recentBlog,
             ]);
} else {
			throw new NotFoundHttpException('The requested page does not exist.');
		 }
	}		 
}
