<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\City;
use backend\models\State;
use backend\models\Post;
use frontend\models\ShareYourTravelStory;

class CityController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['view'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }
	
	public function actionView($slug = NULL) {
		$model = City::find()->where(['slug' => $slug, 'status' => 1])->one();	
		$modelstate = State::find()->where(['id' => $model->state_id, 'status' => 1])->one();
		$travelstory = ShareYourTravelStory::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(6)->all();
		return $this->render('view', [
					'model' => $model,
					'modelstate' => $modelstate,
					'travelstory' => $travelstory,
		]);
    }
}
