<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="daily-current-form">
		    <?php $form = ActiveForm::begin([
					'id' => 'form',
					'enableClientValidation' => true,
                'options' => ['class' => 'form-horizontal', 'enctype' => 'multipart/form-data'],
                'fieldConfig' => [
                    'template' => "{label}{input}{error}",
                ],
		    ]); ?>


		    <div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
		    	<?= $form->field($model, 'name')->textInput(['placeholder' => $model->getAttributeLabel('name')]) ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
		    	<?= $form->field($model, 'post')->textInput(['placeholder' => $model->getAttributeLabel('post')]) ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
                  <?php echo $form->field($model, 'gender')->dropDownList(['male' => 'Male', 'female' => 'Female'], ['prompt' => 'Select Gender']) ?>
			 </div>
			</div>
		    <div class="col-xs-12 col-lg-12 no-padding">
	    		<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?php if (!empty($model->file)) : ?>
					<?php
					echo $form->field($model, 'file')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => false,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
							'initialPreview' => [
								'<img src="/seo/backend/web/images/team/' . $model->file . '" class="file-preview-image" width = "150px">',
							],
						]
					])->label('Upload Image (Size : 370px * 370px)');
					?>
				<?php else: ?>
					<?php
					echo $form->field($model, 'file')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
						]
					])->label('Upload Image (Size : 370px * 370px)');
					?>

				<?php endif; ?>
	    		</div>
			 </div>
            <div class="col-xs-12 col-lg-12 no-padding">
	    		<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?= $form->field($model, 'status')->radioList(['1' => 'Active', '0' => 'Inactive'], ['inline' => true]) ?>
	    		</div>
			</div>
	    	<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
