<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;

/* @var $this yii\web\View */
/* @var $model app\modules\models\State */
/* @var $form yii\widgets\ActiveForm */
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="state-template-form">
		<?php
			if($this->context->action->id == 'update')
				$action = ['update', 'id'=>$_REQUEST['id']];
			else
				$action = ['create'];
		?>
		    <?php $form = ActiveForm::begin([
					'id' => 'state-form',
					'action' => $action,
					'enableClientValidation' => true,
                'fieldConfig' => [
                    'template' => "{input}{error}",
                ],
		    ]); ?>


		    <div class="col-xs-12 col-lg-12 no-padding">
			    <div class="col-xs-6 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'state_id')->dropDownList(ArrayHelper::map(\backend\models\State::find()->where(['status' => 1])->all(),'id','state_name'), ['prompt'=>Yii::t('app', '--- Select State Name ---') ]); ?>
				</div>
				<div class="col-xs-6 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'slug')->textInput(['placeholder' => $model->getAttributeLabel('slug')]) ?>
				</div>
                <div class="col-xs-6 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'heading')->textInput(['placeholder' => $model->getAttributeLabel('heading')]) ?>
				</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
		    	  <?php if (!empty($model->image)) : ?>
					<?php
					echo $form->field($model, 'image')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
							'initialPreview' => [
								'<img src="/backend/web/images/state/' . $model->image . '" class="file-preview-image">',
							],
						]
					])->label('Page Image (Size : 350px * 350px)');
					?>
				<?php else: ?>
					<?php
					echo $form->field($model, 'image')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
						]
					])->label('Page Image (Size : 350px * 350px)');
					?>

				<?php endif; ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
			   <div class="col-xs-12 col-sm-12 col-lg-12">
			    <?= $form->field($model, 'introduction')->widget(Redactor::className(), [
					'options' => [
						'minHeight' => 5000,
						'imageUpload' => ['/redactor/upload/image'],
						'fileUpload' => ['/redactor/upload/file'],
						'plugins' => ['fullscreen']
					]
				])
				?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
		    	<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'meta_title')->textArea(['placeholder' => $model->getAttributeLabel('meta_title')]) ?>
		    	</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?= $form->field($model, 'meta_keyword')->textArea(['placeholder' => $model->getAttributeLabel('meta_keyword')]) ?>
	    		</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?= $form->field($model, 'meta_description')->textArea(['placeholder' => $model->getAttributeLabel('meta_description')]) ?>
	    		</div>
           </div>

			<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
