<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \common\models\LoginForm */

use yii\helpers\Html;
use kartik\form\ActiveForm;
use dektrium\user\widgets\Connect;

$this->title = 'Login';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="row">
    <div class="login-box">
        <div class="login-box-body">
            <div class="login-logo">
                Chronicle<b>INDIA</b>
            </div>
            <h3 class="login-box-msg"><b>Sign in </b></h3>
            <?php
            $form = ActiveForm::begin([
                        'id' => 'login-form',
                        'enableAjaxValidation' => true,
                        'enableClientValidation' => false,
                        'validateOnBlur' => false,
                    ])
            ?>

            <?=
            $form->field($model, 'login', ['inputOptions' => ['autofocus' => 'autofocus', 'class' => 'form-control', 'tabindex' => '1'], 'feedbackIcon' => [
                    'prefix' => 'fa fa-',
                    'default' => 'user',
                    'success' => 'user',
                    'error' => 'user',
                    'defaultOptions' => ['class' => 'text-warning']
                ]
            ])->textInput(['placeholder' => 'Username or Email'])
            ?>

            <?=
            $form->field($model, 'password', ['inputOptions' => ['class' => 'form-control', 'tabindex' => '2'], 'feedbackIcon' => [
                    'prefix' => 'fa fa-',
                    'default' => 'lock',
                    'success' => 'lock',
                    'error' => 'lock',
                    'defaultOptions' => ['class' => 'text-warning']
        ]])->passwordInput(['placeholder' => 'Password'])->label(Yii::t('user', 'Password') . ' (' . Html::a(Yii::t('user', 'Forgot password?'), ['/yadmin/user/recovery/request'], ['tabindex' => '5']) . ')')
            ?>

            <?= $form->field($model, 'rememberMe')->checkbox(['tabindex' => '4']) ?>

            <?= Html::submitButton(Yii::t('user', 'Sign in'), ['class' => 'btn btn-danger btn-block', 'tabindex' => '3']) ?>

            <?php ActiveForm::end(); ?>
            <?=
            Connect::widget([
                'baseAuthUrl' => ['/yadmin/user/security/auth']
            ])
            ?>
        </div>
    </div>
</div>	
