<?php

use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Post Faq';
$this->params['breadcrumbs'][] = ['label' => 'Manage Post', 'url' => ['post/index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-xs-12">
  <div class="col-lg-8 col-sm-8 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> Post Faq List</h3></div>
  <div class="col-lg-4 col-sm-4 col-xs-12 no-padding" style="padding-top: 20px !important;">
	<div class="col-xs-4 left-padding">
  
	</div>
	<div class="col-xs-4 left-padding">
      <?php
			echo Html::a('<i class="fa fa-arrow-circle-o-left"></i> Back', ['post/index'], ['class' => 'btn btn-info btn-large']);
		?>
	</div>
	<div class="col-xs-4 left-padding">
	 <?php
		echo Html::a('<i class="fa fa-plus-circle"></i> Add Post Faq', ['create', 'id' => $ptid], ['class' => 'btn btn-primary btn-large', 'style' => 'margin-left:10px;']);
	?>
	</div>
  </div>
</div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="courses-index">
	<?php $visible = Yii::$app->user->can("/post-faq/create") ? true : false; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'id',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],

		     [
				'attribute' => 'post_id',
				'value' => function ($model) {
				  return $model->contentpost->title;
				},
				'format' => 'raw',
				'contentOptions' => ['style' => 'width: 600px;']
			],
                  [
                                'attribute' => 'Question',
                                'value' => function ($model) {
                                    return $model->question;
                                },
                                'format' => 'html',
                            ],
		   [
			'class' => 'yii\grid\ActionColumn',
			'template' => '{update} {delete}',
			'visible' => $visible,
		    ],
		],
	    ]); ?>
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
