<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;
use yii\helpers\Url;
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="post-form">
		    <?php $form = ActiveForm::begin([
					'id' => 'post-form',
					'enableClientValidation' => true,
                'options' => ['class' => 'form-horizontal', 'enctype' => 'multipart/form-data'],
                'fieldConfig' => [
                    'template' => "{label}{input}{error}",
                ],
		    ]); ?>
            
			<div class="col-xs-12 col-lg-12 no-padding">	
				<div class="col-xs-12 col-sm-8 col-lg-8">
					<?php echo $form->field($model, 'category_id')->dropDownList(['Popular' => 'Popular', 'Pilgrimage' => 'Pilgrimage'], ['prompt' => 'Select Category']) ?>     
				</div>
			</div>
                
		    <div class="col-xs-12 col-lg-12 no-padding">
				<div class="col-xs-12 col-sm-8 col-lg-8">
					<?= $form->field($model, 'state_id')->dropDownList(ArrayHelper::map(\backend\models\State::find()->orderby('state_name ASC')->where(['status' => 1])->all(),'id','state_name'),['class' => 'form-control', 'required' => 'required', 'style' => 'height: 40px;','prompt'=>Yii::t('app', '--- Select State ---'),
					'onchange'=>'
						$.get( "'.Url::toRoute('dependent/state').'", { id: $(this).val() } )
							.done(function( data ) {
								$( "#'.Html::getInputId($model, 'city_id').'" ).html( data );
							}
						);
					']); ?>
				</div>
			</div>
			<div class="col-xs-12 col-lg-12 no-padding">	
				<div class="col-xs-12 col-sm-8 col-lg-8">
					<?= $form->field($model, 'city_id')->dropDownList(ArrayHelper::map(\backend\models\City::find()->orderby('city_name ASC')->where(['state_id' => $model->state_id, 'status' => 1])->all(),'id','city_name'),['class' => 'form-control', 'required' => 'required', 'style' => 'height: 40px;', 'prompt'=>Yii::t('app', '--- Select City ---')]); ?>
				</div>
			</div>
			<div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-8 col-lg-8">
		    	<?=$form->field($model, 'post_id')->widget(Select2::classname(), ['options' => ['multiple' => true, 'selected'=> 'selected', 'prompt'=> 'Select Post'],
            'data' => ArrayHelper::map(\backend\models\Post::find()->orderBy('title')->where(['status' => 1])->all(), 'id', 'title')
				]);
				?>
				</div>
		    </div>
			<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
