<?php
use yii\helpers\Html;

/* @var $this \yii\web\View */
/* @var $content string */
if (Yii::$app->controller->action->id === 'login') {
    echo $this->render('login-layout',['content' => $content]);
} else {
\backend\assets\AppAsset::register($this);
$directoryAsset = Yii::$app->assetManager->getPublishedUrl('@bower') . '/admin-lte';
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
	<meta charset="<?= Yii::$app->charset ?>"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="Keywords" content="">
	<meta name="Description" content="">
	<link rel="shortcut icon" href="<?php echo Yii::$app->request->baseUrl; ?>/images/" type="image/x-icon" />
	<?= Html::csrfMetaTags() ?>
	<title><?= Html::encode($this->title) ?></title>
	<?php $this->head() ?>
	<style>
	 .breadcrumb {
  padding: 8px 15px;
  margin-bottom: 20px;
  list-style: none;
  background-color: #f5f5f5;
  border-radius: 4px;
}
.breadcrumb > li {
  display: inline-block;
}
.breadcrumb > li + li:before {
  padding: 0 5px;
  color: #ccc;
  content: "/\00a0";
}
.breadcrumb > .active {
  color: #777;
}
	</style>
</head>
<body class="skin-black">
<?php $this->beginBody() ?>

<?= $this->render(
	'header.php',
	['directoryAsset' => $directoryAsset]
) ?>

<div class="wrapper row-offcanvas row-offcanvas-left">

	<?= $this->render('left.php', ['directoryAsset' => $directoryAsset]) ?>

	<?= $this->render(
		'content.php',
		['content' => $content, 'directoryAsset' => $directoryAsset]
	) ?>

</div>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
<?php } ?>
