<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="form">
		<?php
			if($this->context->action->id == 'update')
				$action = ['update', 'id'=>$_REQUEST['id']];
			else
				$action = ['create'];
		?>
		    <?php $form = ActiveForm::begin([
					'id' => 'state-form',
					'action' => $action,
					'enableClientValidation' => true,
                'fieldConfig' => [
                    'template' => "{input}{error}",
                ],
		    ]); ?>


		    <div class="col-xs-12 col-lg-12 no-padding">
			    <div class="col-xs-12 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'name')->textInput(['placeholder' => $model->getAttributeLabel('name')]) ?>
				</div>
 <div class="col-xs-12 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'heading')->textInput(['placeholder' => $model->getAttributeLabel('heading')]) ?>
				</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'slug')->textInput(['placeholder' => $model->getAttributeLabel('slug')]) ?>
				</div>
			</div>
			<div class="col-xs-12 col-lg-12 no-padding">
			   <div class="col-xs-12 col-sm-12 col-lg-12">
			    <?= $form->field($model, 'introduction')->widget(Redactor::className(), [
					'options' => [
						'minHeight' => 5000,
						'imageUpload' => ['/redactor/upload/image'],
						'fileUpload' => ['/redactor/upload/file'],
						'plugins' => ['fullscreen']
					]
				])
				?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
		    	<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'meta_title')->textInput(['placeholder' => $model->getAttributeLabel('meta_title')]) ?>
		    	</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?= $form->field($model, 'meta_keyword')->textArea(['placeholder' => $model->getAttributeLabel('meta_keyword')]) ?>
	    		</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?= $form->field($model, 'meta_description')->textArea(['placeholder' => $model->getAttributeLabel('meta_description')]) ?>
	    		</div>
           </div>

			<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
