<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use dektrium\user\helpers\RoleHelper;
use dektrium\user\models\User;
use yii\helpers\ArrayHelper;
use kartik\widgets\Select2;
use yii\widgets\MaskedInput;

$this->title = Yii::t('user', 'User');
$this->params['breadcrumbs'][] = $this->title;
?> 
<div class='row'>
    <div class='col-sm-12'>
        <div class="box box-success">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-plus"></i>  Add user Account</h3>
                <div class="box-tools pull-right">
                    <div class="actions">
                        <?php
                        if (Yii::$app->user->can('/user/index')) {
                            echo Html::a('<i class="fa fa-table "></i> Users List', ["/user"], ['class' => 'btn btn-primary btn-large']);
                        }
                        ?>
                    </div>                        
                </div>
            </div>
            <div class='box-body box-no-padding'>

                <?php
                $form = ActiveForm::begin([
                            'id' => 'add-form',
                            'enableAjaxValidation' => true,
                            'enableClientValidation' => false,
                            'validateOnBlur' => false,
                            'options' => ['class' => 'form-horizontal'],
                            'fieldConfig' => [
                                'template' => "{label}\n<div class=\"col-lg-4\">{input}</div>\n<div class=\"col-lg-6\">{error}</div>",
                                'labelOptions' => ['class' => 'col-lg-2 control-label'],
                            ],
                ]);
                ?>
				<?= $form->field($model, 'email')->textInput(['placeholder' => 'Email ID']) ?>

                <?= $form->field($model, 'username')->textInput(['placeholder' => 'Username']) ?>

                <?= $form->field($model, 'password')->passwordInput(['placeholder' => 'Password']) ?>

                 <?= $form->field($model, 'role')->dropDownList(['superadmin' => 'Super Admin', 'admin' => 'Admin'], ['prompt' => 'Select a role..']) ?>
				 
                <div class="form-actions form-actions-padding-sm">
                    <div class="row">
                        <div class="col-md-10 col-md-offset-2">
                            <?= Html::submitButton(Yii::t('user', 'Save'), ['class' => 'btn btn-primary']) ?>
                            <a href="/user"><input type="button" class="btn" value="Cancel" /></a>
                        </div>
                    </div>
                </div>
                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>