<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;

class Story extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'story';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['heading', 'slug', 'content', 'link', 'create_on', 'create_by', 'status'], 'required', 'message' => ''],
            [['meta_title', 'meta_description', 'create_on', 'update_on', 'image'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status'], 'integer', 'message' => ''],
[['heading', 'slug'], 'unique'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
            'heading' => Yii::t('app', 'Heading'),
            'slug' => Yii::t('app', 'Slug'),
 'link' => Yii::t('app', 'Link'),
			'content' => Yii::t('app', 'Content'),
			'image' => Yii::t('app', 'Image'),
			'meta_title' => Yii::t('app', 'Meta Title'),
			'meta_description' => Yii::t('app', 'Meta Description'),
			'create_on' => Yii::t('app', 'Create On'),
            'create_by' => Yii::t('app', 'Created By'),
            'update_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }

    public function limitTextWords($content = false, $limit = false, $stripTags = false, $ellipsis = false) 
    {
        if ($content && $limit) {
            $content = ($stripTags ? strip_tags($content) : $content);
            $content = explode(' ', $content, $limit+1);
            array_pop($content);
            if ($ellipsis) {
                array_push($content, '...');
            }
            $content = implode(' ', $content);
        }
        return $content;
    }
	
    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			$this->create_on = Yii::$app->formatter->asDatetime($this->create_on, "php:Y-m-d");
$this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = Yii::$app->formatter->asDatetime($this->create_on, "php:Y-m-d");
        }
        
        if (isset($this->heading) && $this->heading != '') {
            $headmain = strtolower($this->heading);
            $this->heading = ucwords($headmain);
        }

        return parent::beforeSave($insert);
    }
    
    
}
