<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\Post;

class PostSearch extends Post
{
   public $catname, $statename, $cityname; 
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'category_id', 'state_id', 'city_id', 'create_on', 'update_by', 'status'], 'integer'],
            [['title', 'meta_title', 'meta_keyword', 'meta_description', 'slug', 'content', 'tag_id', 'weekend_id', 'catname', 'statename', 'cityname', 'create_on', 'update_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Post::find();
       $query->joinWith(['category', 'state', 'city']);
        $dataProvider = new ActiveDataProvider([
            'query' => $query, 'sort'=> ['defaultOrder' => ['id'=>SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
			'category_id' => $this->category_id,
			'state_id' => $this->state_id,
			'city_id' => $this->city_id,
			'create_on' => $this->create_on,
            'create_by' => $this->create_by,
            'update_on' => $this->update_on,
            'update_by' => $this->update_by,
            'status' => $this->status,
        ]);

        $query->andFilterWhere(['like', 'category.name', $this->catname])
                   ->andFilterWhere(['like', 'state.state_name', $this->statename])
                   ->andFilterWhere(['like', 'city.city_name', $this->cityname])
                   ->andFilterWhere(['like', 'title', $this->title])
				   ->andFilterWhere(['or',['like', 'tag_id', $this->tag_id],]);

        return $dataProvider;
    }
}
