<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;

class FamousPlaces extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'famous_places';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['post_id', 'famous_place_name', 'slug', 'introduction', 'create_on', 'create_by'], 'required', 'message' => ''],
            [['post_id', 'create_on', 'update_on', 'famous_place_name', 'introduction', 'meta_title', 'meta_keyword', 'meta_description', 'slug'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
			'post_id' => Yii::t('app', 'Post'),
            'famous_place_name' => Yii::t('app', 'Famous Place Name'),
			'slug' => Yii::t('app', 'Slug'),
			'introduction' => Yii::t('app', 'Introduction'),
			'meta_title' => Yii::t('app', 'Meta Title'),
            'meta_keyword' => Yii::t('app', 'Meta Keyword'),
            'meta_description' => Yii::t('app', 'Meta Description'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }
	
	 public function postall($post_id)
    { 
        $connection = Yii::$app->getDb();
		$result = $connection->createCommand("SELECT * FROM post where id=".$post_id." AND status = 1")->queryOne();
		return $result['title'];
    }
	
	public function setPostArray(array $value)
    {
        $this->post_id = implode(',', $value);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
}
