<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\EmailTemplate;


class EmailTemplateSearch extends EmailTemplate
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'create_on', 'update_by', 'status'], 'integer'],
            [['template_name', 'email_subject', 'template', 'create_on', 'update_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = EmailTemplate::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query, 'sort'=> ['defaultOrder' => ['id'=>SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'create_on' => $this->create_on,
            'create_by' => $this->create_by,
            'update_on' => $this->update_on,
            'update_by' => $this->update_by,
            'status' => $this->status,
        ]);

        $query->andFilterWhere(['like', 'template_name', $this->template_name])
		      ->andFilterWhere(['like', 'email_subject', $this->email_subject]);

    	unset($_SESSION['exportData']);
    	$_SESSION['exportData'] = $dataProvider;

        return $dataProvider;
    }

    public static function getExportData()
    {
	$data = [
			'data'=>$_SESSION['exportData'],
			'fileName'=>'Email-Template-List',
			'title'=>'Email Template List',
			'exportFile'=>'@backend/views/email-template/emailtemplateExportPdfExcel',
		];

	return $data;
    }
}
