<?php
namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;

class CricketCategory extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'cricket_category';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['category_name', 'slug', 'create_on', 'create_by'], 'required', 'message' => ''],
            [['create_on', 'update_on', 'image'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status'], 'integer', 'message' => ''],
        ];
    }
	
	

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
            'category_name' => Yii::t('app', 'Category Name'),
			'slug' => Yii::t('app', 'Slug'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
}
