<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\City;


class CitySearch extends City
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'state_id', 'create_on', 'update_by', 'status'], 'integer'],
            [['city_name', 'introduction', 'meta_title', 'meta_keyword', 'meta_description', 'slug', 'create_on', 'update_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = City::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query, 'sort'=> ['defaultOrder' => ['city_name'=>SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
			'state_id' => $this->state_id,
            'create_on' => $this->create_on,
            'create_by' => $this->create_by,
            'update_on' => $this->update_on,
            'update_by' => $this->update_by,
            'status' => $this->status,
        ]);

        $query->andFilterWhere(['like', 'city_name', $this->city_name]);

    	unset($_SESSION['exportData']);
    	$_SESSION['exportData'] = $dataProvider;

        return $dataProvider;
    }

    public static function getExportData()
    {
	$data = [
			'data'=>$_SESSION['exportData'],
			'fileName'=>'City-List',
			'title'=>'City List',
			'exportFile'=>'@backend/views/city/cityExportPdfExcel',
		];

	return $data;
    }
}
