<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\Tag;
use backend\models\TagSearch;
use backend\models\City;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use pheme\grid\actions\ToggleAction;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;
use Imagine\Image\ManipulatorInterface;

/**
 * StateController implements the CRUD actions for Tag model.
 */
class TagController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actions() 
    {
	    return [
		'toggle' => [
		    'class' => ToggleAction::className(),
		    'modelClass' => 'backend\models\Tag',
		    'attribute' => 'status',
		    // Uncomment to enable flash messages
		    'setFlash' => true,
		],
	    ];
    }
    /**
     * Lists all Tag models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TagSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		$model = new Tag();

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
			'model' => $model,
        ]);
    }

    /**
     * Creates a new Tag model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Tag();
        $searchModel = new TagSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        if($model->load(Yii::$app->request->post())) {
			if ($_FILES['Tag']['name']['image'] != '') {
                $uploadFile = UploadedFile::getInstance($model, 'image');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->image = $fileName;
                $uploadFile->saveAs('images/' . $fileName);
                
                Image::resize(Yii::getAlias('@backend') . '/web/images/' . $fileName,500,300,false,false)
                ->save(Yii::getAlias('@backend') . '/web/images/tag/big/' . $fileName, 
                        ['quality' => 70]);
						
				Image::resize(Yii::getAlias('@backend') . '/web/images/' . $fileName,150,100,false,false)
                ->save(Yii::getAlias('@backend') . '/web/images/tag/small/' . $fileName, 
                        ['quality' => 70]);		
                        
                unlink(Yii::getAlias('@backend') . '/web/images/' . $fileName);	        
            }
            if ($_FILES['Tag']['name']['image'] == '') {
                $model->image = '';
            }
           $model->slug = $this->seofriendlyurl($_POST['Tag']['slug']);
       	if($model->save(false))
			return $this->redirect(['index']);
		else
			return $this->render('index', [
               		 'model' => $model,
					 'searchModel' => $searchModel,
			         'dataProvider' => $dataProvider,
			]);

            } else {
            return $this->render('index', [
                'model' => $model,'searchModel' => $searchModel,'dataProvider' => $dataProvider,
            ]);
            }
    }

    /**
     * Updates an existing Tag model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
   public function actionUpdate($id)
    {
        $model = $this->findModel($id);
	    $searchModel = new TagSearch();
		$old_img = $model->image;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        if ($model->load(Yii::$app->request->post())) {
		  if ($_FILES['Tag']['name']['image'] != '') {
                if ($old_img != ''):
                    unlink(Yii::getAlias('@backend') . '/web/images/tag/big/' . $old_img);
					unlink(Yii::getAlias('@backend') . '/web/images/tag/small/' . $old_img);
                endif;
                $uploadFile = UploadedFile::getInstance($model, 'image');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->image = $fileName;
                $uploadFile->saveAs('images/' . $fileName);
                Image::resize(Yii::getAlias('@backend') . '/web/images/' . $fileName,500,300,false,false)->save(Yii::getAlias('@backend') . '/web/images/tag/big/' . $fileName,['quality' => 70]);
                Image::resize(Yii::getAlias('@backend') . '/web/images/' . $fileName,150,100,false,false)->save(Yii::getAlias('@backend') . '/web/images/tag/small/' . $fileName,['quality' => 70]);
				unlink(Yii::getAlias('@backend') . '/web/images/' . $fileName);	
            }
            if ($_FILES['Tag']['name']['image'] == '') {
                $model->image = $old_img;
            }	
           $model->slug = $this->seofriendlyurl($_POST['Tag']['slug']);
		if($model->save(false))
			return $this->redirect(['index']);
		else
			return $this->render('index', [
               		 'model' => $model,
					 'searchModel' => $searchModel,
			         'dataProvider' => $dataProvider,
			]);
        } else {
            return $this->render('index', [
                'model' => $model,
				'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }
    }
    
    public function actionDelete($id)
    {
		$this->findModel($id)->delete();
		return $this->redirect(['index']);
    }
	
    /**
     * Finds the Tag model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tag the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Tag::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
	
	public function seofriendlyurl($string){
		$string = str_replace(array('[\', \']'), '', $string);
		$string = preg_replace('/\[.*\]/U', '', $string);
		$string = preg_replace('/&(amp;)?#?[a-z0-9]+;/i', '-', $string);
		$string = htmlentities($string, ENT_COMPAT, 'utf-8');
		$string = preg_replace('/&([a-z])(acute|uml|circ|grave|ring|cedil|slash|tilde|caron|lig|quot|rsquo);/i', '\\1', $string );
		$string = preg_replace(array('/[^a-z0-9]/i', '/[-]+/') , '-', $string);
		return strtolower(trim($string, '-'));
   }
    
    
}
