<?php

namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\Substory;
use backend\models\SubstorySearch;
use backend\models\UploadForm;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;
use Imagine\Image\ManipulatorInterface;

class SubstoryController extends Controller
{
    /**
     * @inheritdoc
     */
   
    public $enableCsrfValidation = false;
    
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Substory models.
     * @return mixed
     */
    public function actionIndex($id)
    {
        $searchModel = new SubstorySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams, $id);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'packageid' => $id,
        ]);
    }

    

    /**
     * Creates a new Substory model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Substory();
    
        if ($model->load(Yii::$app->request->post())) {
			    if ($_FILES['Substory']['name']['image'] != '') {
					$uploadFile = UploadedFile::getInstance($model, 'image');

					$random_digit = rand(0000, 9999);
					$fileName = $random_digit . "_{$uploadFile}";
					$model->image = $fileName;
					$uploadFile->saveAs(Yii::getAlias('@backend') . '/web/images/story/substory/' . $fileName);
        
				}
				if ($_FILES['Substory']['name']['image'] == '') {
					$model->image = '';
				}

			 $model->story_id = $id;
			 $model->save(false);
            return $this->redirect(['index','id' => $id]);
        } else {
            return $this->render('create', [
                'model' => $model,
                'packageid' => $id,
            ]);
        }
    }

    /**
     * Updates an existing Substory model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
     $model = $this->findModel($id);
	 $oldd_img = $model->image;
        if ($model->load(Yii::$app->request->post())) {
			if ($_FILES['Substory']['name']['image'] != '') {

                $uploadFile = UploadedFile::getInstance($model, 'image');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->image = $fileName;
                $uploadFile->saveAs(Yii::getAlias('@backend') . '/web/images/story/substory/' . $fileName);
	
            }
            if ($_FILES['Substory']['name']['image'] == '') {
                $model->image = $oldd_img;
            }
           $model->save();
             return $this->redirect(['index','id' => $model->story_id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'packageid' => $model->story_id,
            ]);
        }
    }
    
    /**
     * Finds the Substory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Substory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Substory::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    
}
