<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\PostMore;
use backend\models\PostMoreSearch;
use backend\models\UploadForm;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;

class PostMoreController extends Controller
{
    /**
     * @inheritdoc
     */
     
    public $enableCsrfValidation = false;
    
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
    /**
     * Lists all PostMore models.
     * @return mixed
     */
    public function actionIndex($id)
    {
        $searchModel = new PostMoreSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams, $id);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
			'ptid' => $id,
        ]);
    }

    

    /**
     * Creates a new PostMore model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new PostMore();

        if ($model->load(Yii::$app->request->post())) {
            $connection = Yii::$app->getDb();    
             $commandd = $connection->createCommand('select * from post where id='.$id)->queryOne();
			 $connection->close();
			 $model->post_id = $id;
			 $model->save(false);
            return $this->redirect(['index','id' => $id]);
        } else {
            return $this->render('create', [
                'model' => $model,
                'magid' => $id,
            ]);
        }
    }

    /**
     * Updates an existing PostMore model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
           $model->save();
             return $this->redirect(['index','id' => $model->post_id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'postid' => $model->post_id,
            ]);
        }
    }

    public function actionDelete($id)
    {
		$this->findModel($id)->delete();
		return $this->redirect(['index']);
    }

    /**
     * Finds the PostMore model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PostMore the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PostMore::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    
}
