<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\Cricket;
use backend\models\CricketSearch;
use backend\models\UploadForm;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;

class CricketController extends Controller
{
    /**
     * @inheritdoc
     */
    public $enableCsrfValidation = false;
	
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Cricket models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CricketSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Creates a new Cricket model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Cricket();
        if ($model->load(Yii::$app->request->post())) {
           if ($_FILES['Cricket']['name']['image'] != '') {
                $uploadFile = UploadedFile::getInstance($model, 'image');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->image = $fileName;
                $uploadFile->saveAs('images/cricket/' . $fileName);
       
            }
            if ($_FILES['Cricket']['name']['image'] == '') {
                $model->image = '';
            }
			$model->slug = $this->seofriendlyurl($_POST['Cricket']['slug']);
			$model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Cricket model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
       $old_img = $model->image;
		if ($model->load(Yii::$app->request->post())) {
               if ($_FILES['Cricket']['name']['image'] != '') {
                if ($old_img != ''):
                    unlink(Yii::getAlias('@backend') . '/web/images/cricket/' . $old_img);
                endif;
                $uploadFile = UploadedFile::getInstance($model, 'image');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->image = $fileName;
                $uploadFile->saveAs('images/cricket/' . $fileName);
            }
            if ($_FILES['Cricket']['name']['image'] == '') {
                $model->image = $old_img;
            }
			$model->slug = $this->seofriendlyurl($_POST['Cricket']['slug']);
            $model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionDelete($id)
    {
		$this->findModel($id)->delete();

        return $this->redirect(['index']);
    }
    
    
    /**
     * Finds the Cricket model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Cricket the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Cricket::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
	
	public function seofriendlyurl($string){
		$string = str_replace(array('[\', \']'), '', $string);
		$string = preg_replace('/\[.*\]/U', '', $string);
		$string = preg_replace('/&(amp;)?#?[a-z0-9]+;/i', '-', $string);
		$string = htmlentities($string, ENT_COMPAT, 'utf-8');
		$string = preg_replace('/&([a-z])(acute|uml|circ|grave|ring|cedil|slash|tilde|caron|lig|quot|rsquo);/i', '\\1', $string );
		$string = preg_replace(array('/[^a-z0-9]/i', '/[-]+/') , '-', $string);
		return strtolower(trim($string, '-'));
   }
   
   public function actionUpload() {
		$model = new UploadForm();

		if (Yii::$app->request->isPost) {
            $model->file = UploadedFile::getInstanceByName('file');
            $random_digit = rand(0000, 9999);
            $fileName = $random_digit . "_{$model->file->baseName}";
            if ($model->file) {
                $model->file->saveAs(Yii::getAlias('@backend') . '/web/uploads/images/' . $fileName . '.' . $model->file->extension);
            }
        }

        // Get file link
        $res = array (
            'filelink'    => '/backend/web/uploads/images/' . $fileName . '.' . $model->file->extension,
        );

        // Response data
        return json_encode($res);
    }
}
