<?php
return [
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'timeZone' => 'Asia/Kolkata',
    'vendorPath' => dirname(dirname(__DIR__)) . '/vendor',
    'components' => [
	    'assetManager' => [
          //'forceCopy' => YII_ENV_DEV ? true : false,
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'errorHandler' => [
            'errorAction' => 'frontend/site/error',
        ],
		'authManager' => [
			'class' => 'yii\rbac\DbManager', // or use 'yii\rbac\PhpManager'
			'ruleTable' => 'auth_rule', // Optional
			'itemTable' => 'auth_item', // Optional
			'itemChildTable' => 'auth_item_child', // Optional
			'assignmentTable' => 'auth_assignment', // Optional
		],
		'user' => [
				 'identityClass' => 'dektrium\user\models\User',
				 'enableAutoLogin' => true,
		   ],
	 'urlManager' => [
	        'class' => 'yii\web\urlManager',
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [],
        ]	   
    ],
	'modules' => [
	'admin' => [
        'class' => 'mdm\admin\Module',
    ],
    'user' => [
        'class' => 'dektrium\user\Module',
        // you will configure your module inside this file
        // or if need different configuration for frontend and backend you may
        // configure in needed configs
    ],
   ],
  'as access' => [
        'class' => 'mdm\admin\components\AccessControl',
        'allowActions' => [
            'site/*',
			'contact-us/*',
			'page/*',
		]
    ]
];
